// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the domain verifications.
func (c *Client) ListDomainVerifications(ctx context.Context, params *ListDomainVerificationsInput, optFns ...func(*Options)) (*ListDomainVerificationsOutput, error) {
	if params == nil {
		params = &ListDomainVerificationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDomainVerifications", params, optFns, c.addOperationListDomainVerificationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDomainVerificationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDomainVerificationsInput struct {

	//  The maximum number of results to return.
	MaxResults *int32

	//  A pagination token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDomainVerificationsOutput struct {

	//  Information about the domain verifications.
	//
	// This member is required.
	Items []types.DomainVerificationSummary

	//  A pagination token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDomainVerificationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDomainVerifications{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDomainVerifications{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDomainVerifications"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDomainVerifications(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDomainVerificationsPaginatorOptions is the paginator options for
// ListDomainVerifications
type ListDomainVerificationsPaginatorOptions struct {
	//  The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDomainVerificationsPaginator is a paginator for ListDomainVerifications
type ListDomainVerificationsPaginator struct {
	options   ListDomainVerificationsPaginatorOptions
	client    ListDomainVerificationsAPIClient
	params    *ListDomainVerificationsInput
	nextToken *string
	firstPage bool
}

// NewListDomainVerificationsPaginator returns a new
// ListDomainVerificationsPaginator
func NewListDomainVerificationsPaginator(client ListDomainVerificationsAPIClient, params *ListDomainVerificationsInput, optFns ...func(*ListDomainVerificationsPaginatorOptions)) *ListDomainVerificationsPaginator {
	if params == nil {
		params = &ListDomainVerificationsInput{}
	}

	options := ListDomainVerificationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDomainVerificationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDomainVerificationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDomainVerifications page.
func (p *ListDomainVerificationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDomainVerificationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDomainVerifications(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDomainVerificationsAPIClient is a client that implements the
// ListDomainVerifications operation.
type ListDomainVerificationsAPIClient interface {
	ListDomainVerifications(context.Context, *ListDomainVerificationsInput, ...func(*Options)) (*ListDomainVerificationsOutput, error)
}

var _ ListDomainVerificationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDomainVerifications(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDomainVerifications",
	}
}
