// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a resource configuration. A resource configuration defines a specific
// resource. You can associate a resource configuration with a service network or a
// VPC endpoint.
func (c *Client) CreateResourceConfiguration(ctx context.Context, params *CreateResourceConfigurationInput, optFns ...func(*Options)) (*CreateResourceConfigurationOutput, error) {
	if params == nil {
		params = &CreateResourceConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResourceConfiguration", params, optFns, c.addOperationCreateResourceConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResourceConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResourceConfigurationInput struct {

	// The name of the resource configuration. The name must be unique within the
	// account. The valid characters are a-z, 0-9, and hyphens (-). You can't use a
	// hyphen as the first or last character, or immediately after another hyphen.
	//
	// This member is required.
	Name *string

	// The type of resource configuration. A resource configuration can be one of the
	// following types:
	//
	//   - SINGLE - A single resource.
	//
	//   - GROUP - A group of resources. You must create a group resource
	//   configuration before you create a child resource configuration.
	//
	//   - CHILD - A single resource that is part of a group resource configuration.
	//
	//   - ARN - An Amazon Web Services resource.
	//
	// This member is required.
	Type types.ResourceConfigurationType

	// (SINGLE, GROUP, ARN) Specifies whether the resource configuration can be
	// associated with a sharable service network. The default is false.
	AllowAssociationToShareableServiceNetwork *bool

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If you retry a request that completed successfully using the
	// same client token and parameters, the retry succeeds without performing any
	// actions. If the parameters aren't identical, the retry fails.
	ClientToken *string

	//  A custom domain name for your resource configuration. Additionally, provide a
	// DomainVerificationID to prove your ownership of a domain.
	CustomDomainName *string

	//  The domain verification ID of your verified custom domain name. If you don't
	// provide an ID, you must configure the DNS settings yourself.
	DomainVerificationIdentifier *string

	//  (GROUP) The group domain for a group resource configuration. Any domains that
	// you create for the child resource are subdomains of the group domain. Child
	// resources inherit the verification status of the domain.
	GroupDomain *string

	// (SINGLE, GROUP, CHILD) The TCP port ranges that a consumer can use to access a
	// resource configuration (for example: 1-65535). You can separate port ranges
	// using commas (for example: 1,2,22-30).
	PortRanges []string

	// (SINGLE, GROUP) The protocol accepted by the resource configuration.
	Protocol types.ProtocolType

	// Identifies the resource configuration in one of the following ways:
	//
	//   - Amazon Resource Name (ARN) - Supported resource-types that are provisioned
	//   by Amazon Web Services services, such as RDS databases, can be identified by
	//   their ARN.
	//
	//   - Domain name - Any domain name that is publicly resolvable.
	//
	//   - IP address - For IPv4 and IPv6, only IP addresses in the VPC are supported.
	ResourceConfigurationDefinition types.ResourceConfigurationDefinition

	// (CHILD) The ID or ARN of the parent resource configuration of type GROUP . This
	// is used to associate a child resource configuration with a group resource
	// configuration.
	ResourceConfigurationGroupIdentifier *string

	// (SINGLE, GROUP, ARN) The ID or ARN of the resource gateway used to connect to
	// the resource configuration. For a child resource configuration, this value is
	// inherited from the parent resource configuration.
	ResourceGatewayIdentifier *string

	// The tags for the resource configuration.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateResourceConfigurationOutput struct {

	// Specifies whether the resource configuration can be associated with a sharable
	// service network.
	AllowAssociationToShareableServiceNetwork *bool

	// The Amazon Resource Name (ARN) of the resource configuration.
	Arn *string

	// The date and time that the resource configuration was created, in ISO-8601
	// format.
	CreatedAt *time.Time

	//  The custom domain name for your resource configuration.
	CustomDomainName *string

	//  The verification ID ARN
	DomainVerificationArn *string

	//  The domain name verification ID.
	DomainVerificationId *string

	// The reason that the request failed.
	FailureReason *string

	//  (GROUP) The group domain for a group resource configuration. Any domains that
	// you create for the child resource are subdomains of the group domain. Child
	// resources inherit the verification status of the domain.
	GroupDomain *string

	// The ID of the resource configuration.
	Id *string

	// The name of the resource configuration.
	Name *string

	// The port range.
	PortRanges []string

	// The protocol.
	Protocol types.ProtocolType

	// Identifies the resource configuration in one of the following ways:
	//
	//   - Amazon Resource Name (ARN) - Supported resource-types that are provisioned
	//   by Amazon Web Services services, such as RDS databases, can be identified by
	//   their ARN.
	//
	//   - Domain name - Any domain name that is publicly resolvable.
	//
	//   - IP address - For IPv4 and IPv6, only IP addresses in the VPC are supported.
	ResourceConfigurationDefinition types.ResourceConfigurationDefinition

	// The ID of the parent resource configuration of type GROUP .
	ResourceConfigurationGroupId *string

	// The ID of the resource gateway associated with the resource configuration.
	ResourceGatewayId *string

	// The current status of the resource configuration.
	Status types.ResourceConfigurationStatus

	// The type of resource configuration. A resource configuration can be one of the
	// following types:
	//
	//   - SINGLE - A single resource.
	//
	//   - GROUP - A group of resources. You must create a group resource
	//   configuration before you create a child resource configuration.
	//
	//   - CHILD - A single resource that is part of a group resource configuration.
	//
	//   - ARN - An Amazon Web Services resource.
	Type types.ResourceConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResourceConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResourceConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateResourceConfigurationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateResourceConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResourceConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateResourceConfiguration struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateResourceConfiguration) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateResourceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateResourceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateResourceConfigurationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateResourceConfigurationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateResourceConfiguration{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateResourceConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResourceConfiguration",
	}
}
