// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/transfer/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a web app based on specified parameters, and returns the ID for the new
// web app. You can configure the web app to be publicly accessible or hosted
// within a VPC.
//
// For more information about using VPC endpoints with Transfer Family, see [Create a Transfer Family web app in a VPC].
//
// [Create a Transfer Family web app in a VPC]: https://docs.aws.amazon.com/transfer/latest/userguide/create-webapp-in-vpc.html
func (c *Client) CreateWebApp(ctx context.Context, params *CreateWebAppInput, optFns ...func(*Options)) (*CreateWebAppOutput, error) {
	if params == nil {
		params = &CreateWebAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWebApp", params, optFns, c.addOperationCreateWebAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWebAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWebAppInput struct {

	// You can provide a structure that contains the details for the identity provider
	// to use with your web app.
	//
	// For more details about this parameter, see [Configure your identity provider for Transfer Family web apps].
	//
	// [Configure your identity provider for Transfer Family web apps]: https://docs.aws.amazon.com/transfer/latest/userguide/webapp-identity-center.html
	//
	// This member is required.
	IdentityProviderDetails types.WebAppIdentityProviderDetails

	// The AccessEndpoint is the URL that you provide to your users for them to
	// interact with the Transfer Family web app. You can specify a custom URL or use
	// the default value.
	//
	// Before you enter a custom URL for this parameter, follow the steps described in [Update your access endpoint with a custom URL]
	// .
	//
	// [Update your access endpoint with a custom URL]: https://docs.aws.amazon.com/transfer/latest/userguide/webapp-customize.html
	AccessEndpoint *string

	// The endpoint configuration for the web app. You can specify whether the web app
	// endpoint is publicly accessible or hosted within a VPC.
	EndpointDetails types.WebAppEndpointDetails

	// Key-value pairs that can be used to group and search for web apps.
	Tags []types.Tag

	//  Setting for the type of endpoint policy for the web app. The default value is
	// STANDARD .
	//
	// If you are creating the web app in an Amazon Web Services GovCloud (US) Region,
	// you can set this parameter to FIPS .
	WebAppEndpointPolicy types.WebAppEndpointPolicy

	// A union that contains the value for number of concurrent connections or the
	// user sessions on your web app.
	WebAppUnits types.WebAppUnits

	noSmithyDocumentSerde
}

type CreateWebAppOutput struct {

	// Returns a unique identifier for the web app.
	//
	// This member is required.
	WebAppId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWebAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateWebApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateWebApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWebApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWebAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWebApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWebApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWebApp",
	}
}
