// Code generated by smithy-go-codegen DO NOT EDIT.

package textract

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/textract/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts the asynchronous analysis of invoices or receipts for data like contact
// information, items purchased, and vendor names.
//
// StartExpenseAnalysis can analyze text in documents that are in JPEG, PNG, and
// PDF format. The documents must be stored in an Amazon S3 bucket. Use the DocumentLocation
// parameter to specify the name of your S3 bucket and the name of the document in
// that bucket.
//
// StartExpenseAnalysis returns a job identifier ( JobId ) that you will provide to
// GetExpenseAnalysis to retrieve the results of the operation. When the analysis
// of the input invoices/receipts is finished, Amazon Textract publishes a
// completion status to the Amazon Simple Notification Service (Amazon SNS) topic
// that you provide to the NotificationChannel . To obtain the results of the
// invoice and receipt analysis operation, ensure that the status value published
// to the Amazon SNS topic is SUCCEEDED . If so, call GetExpenseAnalysis, and pass the job
// identifier ( JobId ) that was returned by your call to StartExpenseAnalysis .
//
// For more information, see [Analyzing Invoices and Receipts].
//
// [Analyzing Invoices and Receipts]: https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html
func (c *Client) StartExpenseAnalysis(ctx context.Context, params *StartExpenseAnalysisInput, optFns ...func(*Options)) (*StartExpenseAnalysisOutput, error) {
	if params == nil {
		params = &StartExpenseAnalysisInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartExpenseAnalysis", params, optFns, c.addOperationStartExpenseAnalysisMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartExpenseAnalysisOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartExpenseAnalysisInput struct {

	// The location of the document to be processed.
	//
	// This member is required.
	DocumentLocation *types.DocumentLocation

	// The idempotent token that's used to identify the start request. If you use the
	// same token with multiple StartDocumentTextDetection requests, the same JobId is
	// returned. Use ClientRequestToken to prevent the same job from being
	// accidentally started more than once. For more information, see [Calling Amazon Textract Asynchronous Operations]
	//
	// [Calling Amazon Textract Asynchronous Operations]: https://docs.aws.amazon.com/textract/latest/dg/api-async.html
	ClientRequestToken *string

	// An identifier you specify that's included in the completion notification
	// published to the Amazon SNS topic. For example, you can use JobTag to identify
	// the type of document that the completion notification corresponds to (such as a
	// tax form or a receipt).
	JobTag *string

	// The KMS key used to encrypt the inference results. This can be in either Key ID
	// or Key Alias format. When a KMS key is provided, the KMS key will be used for
	// server-side encryption of the objects in the customer bucket. When this
	// parameter is not enabled, the result will be encrypted server side,using SSE-S3.
	KMSKeyId *string

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the
	// completion status of the operation to.
	NotificationChannel *types.NotificationChannel

	// Sets if the output will go to a customer defined bucket. By default, Amazon
	// Textract will save the results internally to be accessed by the
	// GetExpenseAnalysis operation.
	OutputConfig *types.OutputConfig

	noSmithyDocumentSerde
}

type StartExpenseAnalysisOutput struct {

	// A unique identifier for the text detection job. The JobId is returned from
	// StartExpenseAnalysis . A JobId value is only valid for 7 days.
	JobId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartExpenseAnalysisMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartExpenseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartExpenseAnalysis{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartExpenseAnalysis"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartExpenseAnalysisValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartExpenseAnalysis(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartExpenseAnalysis(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartExpenseAnalysis",
	}
}
