// Code generated by smithy-go-codegen DO NOT EDIT.

package supplychain

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/supplychain/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables you to programmatically view the list of Amazon Web Services Supply
// Chain data lake namespaces. Developers can view the namespaces and the
// corresponding information such as description for a given instance ID. Note that
// this API only return custom namespaces, instance pre-defined namespaces are not
// included.
func (c *Client) ListDataLakeNamespaces(ctx context.Context, params *ListDataLakeNamespacesInput, optFns ...func(*Options)) (*ListDataLakeNamespacesOutput, error) {
	if params == nil {
		params = &ListDataLakeNamespacesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDataLakeNamespaces", params, optFns, c.addOperationListDataLakeNamespacesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDataLakeNamespacesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters of ListDataLakeNamespaces.
type ListDataLakeNamespacesInput struct {

	// The Amazon Web Services Supply Chain instance identifier.
	//
	// This member is required.
	InstanceId *string

	// The max number of namespaces to fetch in this paginated request.
	MaxResults *int32

	// The pagination token to fetch next page of namespaces.
	NextToken *string

	noSmithyDocumentSerde
}

// The response parameters of ListDataLakeNamespaces.
type ListDataLakeNamespacesOutput struct {

	// The list of fetched namespace details. Noted it only contains custom
	// namespaces, pre-defined namespaces are not included.
	//
	// This member is required.
	Namespaces []types.DataLakeNamespace

	// The pagination token to fetch next page of namespaces.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDataLakeNamespacesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDataLakeNamespaces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDataLakeNamespaces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDataLakeNamespaces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDataLakeNamespacesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDataLakeNamespaces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDataLakeNamespacesPaginatorOptions is the paginator options for
// ListDataLakeNamespaces
type ListDataLakeNamespacesPaginatorOptions struct {
	// The max number of namespaces to fetch in this paginated request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDataLakeNamespacesPaginator is a paginator for ListDataLakeNamespaces
type ListDataLakeNamespacesPaginator struct {
	options   ListDataLakeNamespacesPaginatorOptions
	client    ListDataLakeNamespacesAPIClient
	params    *ListDataLakeNamespacesInput
	nextToken *string
	firstPage bool
}

// NewListDataLakeNamespacesPaginator returns a new ListDataLakeNamespacesPaginator
func NewListDataLakeNamespacesPaginator(client ListDataLakeNamespacesAPIClient, params *ListDataLakeNamespacesInput, optFns ...func(*ListDataLakeNamespacesPaginatorOptions)) *ListDataLakeNamespacesPaginator {
	if params == nil {
		params = &ListDataLakeNamespacesInput{}
	}

	options := ListDataLakeNamespacesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDataLakeNamespacesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDataLakeNamespacesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDataLakeNamespaces page.
func (p *ListDataLakeNamespacesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDataLakeNamespacesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDataLakeNamespaces(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDataLakeNamespacesAPIClient is a client that implements the
// ListDataLakeNamespaces operation.
type ListDataLakeNamespacesAPIClient interface {
	ListDataLakeNamespaces(context.Context, *ListDataLakeNamespacesInput, ...func(*Options)) (*ListDataLakeNamespacesOutput, error)
}

var _ ListDataLakeNamespacesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDataLakeNamespaces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDataLakeNamespaces",
	}
}
