// Code generated by smithy-go-codegen DO NOT EDIT.

package socialmessaging

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/socialmessaging/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new WhatsApp message template using a template from Meta's template
// library.
func (c *Client) CreateWhatsAppMessageTemplateFromLibrary(ctx context.Context, params *CreateWhatsAppMessageTemplateFromLibraryInput, optFns ...func(*Options)) (*CreateWhatsAppMessageTemplateFromLibraryOutput, error) {
	if params == nil {
		params = &CreateWhatsAppMessageTemplateFromLibraryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateWhatsAppMessageTemplateFromLibrary", params, optFns, c.addOperationCreateWhatsAppMessageTemplateFromLibraryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateWhatsAppMessageTemplateFromLibraryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateWhatsAppMessageTemplateFromLibraryInput struct {

	// The ID of the WhatsApp Business Account to associate with this template.
	//
	// This member is required.
	Id *string

	// The template configuration from Meta's library, including customizations for
	// buttons and body text.
	//
	// This member is required.
	MetaLibraryTemplate *types.MetaLibraryTemplate

	noSmithyDocumentSerde
}

type CreateWhatsAppMessageTemplateFromLibraryOutput struct {

	// The category of the template (for example, UTILITY or MARKETING).
	Category *string

	// The numeric ID assigned to the template by Meta.
	MetaTemplateId *string

	// The status of the created template (for example, PENDING or APPROVED).
	TemplateStatus *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateWhatsAppMessageTemplateFromLibraryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateWhatsAppMessageTemplateFromLibrary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateWhatsAppMessageTemplateFromLibrary{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateWhatsAppMessageTemplateFromLibrary"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateWhatsAppMessageTemplateFromLibraryValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateWhatsAppMessageTemplateFromLibrary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateWhatsAppMessageTemplateFromLibrary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateWhatsAppMessageTemplateFromLibrary",
	}
}
