// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all resources associated with a specific tenant.
//
// This operation returns a list of resources (email identities, configuration
// sets, or email templates) that are associated with the specified tenant. You can
// optionally filter the results by resource type.
func (c *Client) ListTenantResources(ctx context.Context, params *ListTenantResourcesInput, optFns ...func(*Options)) (*ListTenantResourcesOutput, error) {
	if params == nil {
		params = &ListTenantResourcesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTenantResources", params, optFns, c.addOperationListTenantResourcesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTenantResourcesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to list resources associated with a specific tenant.
type ListTenantResourcesInput struct {

	// The name of the tenant to list resources for.
	//
	// This member is required.
	TenantName *string

	// A map of filter keys and values for filtering the list of tenant resources.
	// Currently, the only supported filter key is RESOURCE_TYPE .
	Filter map[string]string

	// A token returned from a previous call to ListTenantResources to indicate the
	// position in the list of tenant resources.
	NextToken *string

	// The number of results to show in a single call to ListTenantResources . If the
	// number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int32

	noSmithyDocumentSerde
}

// Information about resources associated with a specific tenant.
type ListTenantResourcesOutput struct {

	// A token that indicates that there are additional resources to list. To view
	// additional resources, issue another request to ListTenantResources , and pass
	// this token in the NextToken parameter.
	NextToken *string

	// An array that contains information about each resource associated with the
	// tenant.
	TenantResources []types.TenantResource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTenantResourcesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTenantResources{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTenantResources{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTenantResources"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTenantResourcesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTenantResources(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTenantResourcesPaginatorOptions is the paginator options for
// ListTenantResources
type ListTenantResourcesPaginatorOptions struct {
	// The number of results to show in a single call to ListTenantResources . If the
	// number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTenantResourcesPaginator is a paginator for ListTenantResources
type ListTenantResourcesPaginator struct {
	options   ListTenantResourcesPaginatorOptions
	client    ListTenantResourcesAPIClient
	params    *ListTenantResourcesInput
	nextToken *string
	firstPage bool
}

// NewListTenantResourcesPaginator returns a new ListTenantResourcesPaginator
func NewListTenantResourcesPaginator(client ListTenantResourcesAPIClient, params *ListTenantResourcesInput, optFns ...func(*ListTenantResourcesPaginatorOptions)) *ListTenantResourcesPaginator {
	if params == nil {
		params = &ListTenantResourcesInput{}
	}

	options := ListTenantResourcesPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTenantResourcesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTenantResourcesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTenantResources page.
func (p *ListTenantResourcesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTenantResourcesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTenantResources(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTenantResourcesAPIClient is a client that implements the
// ListTenantResources operation.
type ListTenantResourcesAPIClient interface {
	ListTenantResources(context.Context, *ListTenantResourcesInput, ...func(*Options)) (*ListTenantResourcesOutput, error)
}

var _ ListTenantResourcesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTenantResources(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTenantResources",
	}
}
