// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List reputation entities in your Amazon SES account in the current Amazon Web
// Services Region. You can filter the results by entity type, reputation impact,
// sending status, or entity reference prefix.
//
// Reputation entities represent resources in your account that have reputation
// tracking and management capabilities. Use this operation to get an overview of
// all entities and their current reputation status.
func (c *Client) ListReputationEntities(ctx context.Context, params *ListReputationEntitiesInput, optFns ...func(*Options)) (*ListReputationEntitiesOutput, error) {
	if params == nil {
		params = &ListReputationEntitiesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReputationEntities", params, optFns, c.addOperationListReputationEntitiesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReputationEntitiesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to list reputation entities with optional filtering.
type ListReputationEntitiesInput struct {

	// An object that contains filters to apply when listing reputation entities. You
	// can filter by entity type, reputation impact, sending status, or entity
	// reference prefix.
	Filter map[string]string

	// A token returned from a previous call to ListReputationEntities to indicate the
	// position in the list of reputation entities.
	NextToken *string

	// The number of results to show in a single call to ListReputationEntities . If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	PageSize *int32

	noSmithyDocumentSerde
}

// A list of reputation entities in your account.
type ListReputationEntitiesOutput struct {

	// A token that indicates that there are additional reputation entities to list.
	// To view additional reputation entities, issue another request to
	// ListReputationEntities , and pass this token in the NextToken parameter.
	NextToken *string

	// An array that contains information about the reputation entities in your
	// account.
	ReputationEntities []types.ReputationEntity

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReputationEntitiesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListReputationEntities{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListReputationEntities{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReputationEntities"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReputationEntities(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListReputationEntitiesPaginatorOptions is the paginator options for
// ListReputationEntities
type ListReputationEntitiesPaginatorOptions struct {
	// The number of results to show in a single call to ListReputationEntities . If
	// the number of results is larger than the number you specified in this parameter,
	// then the response includes a NextToken element, which you can use to obtain
	// additional results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListReputationEntitiesPaginator is a paginator for ListReputationEntities
type ListReputationEntitiesPaginator struct {
	options   ListReputationEntitiesPaginatorOptions
	client    ListReputationEntitiesAPIClient
	params    *ListReputationEntitiesInput
	nextToken *string
	firstPage bool
}

// NewListReputationEntitiesPaginator returns a new ListReputationEntitiesPaginator
func NewListReputationEntitiesPaginator(client ListReputationEntitiesAPIClient, params *ListReputationEntitiesInput, optFns ...func(*ListReputationEntitiesPaginatorOptions)) *ListReputationEntitiesPaginator {
	if params == nil {
		params = &ListReputationEntitiesInput{}
	}

	options := ListReputationEntitiesPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListReputationEntitiesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListReputationEntitiesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListReputationEntities page.
func (p *ListReputationEntitiesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListReputationEntitiesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListReputationEntities(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListReputationEntitiesAPIClient is a client that implements the
// ListReputationEntities operation.
type ListReputationEntitiesAPIClient interface {
	ListReputationEntities(context.Context, *ListReputationEntitiesInput, ...func(*Options)) (*ListReputationEntitiesOutput, error)
}

var _ ListReputationEntitiesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListReputationEntities(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReputationEntities",
	}
}
