// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates configuration options for Security Hub.
func (c *Client) UpdateSecurityHubConfiguration(ctx context.Context, params *UpdateSecurityHubConfigurationInput, optFns ...func(*Options)) (*UpdateSecurityHubConfigurationOutput, error) {
	if params == nil {
		params = &UpdateSecurityHubConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateSecurityHubConfiguration", params, optFns, c.addOperationUpdateSecurityHubConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateSecurityHubConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateSecurityHubConfigurationInput struct {

	// Whether to automatically enable new controls when they are added to standards
	// that are enabled.
	//
	// By default, this is set to true , and new controls are enabled automatically. To
	// not automatically enable new controls, set this to false .
	//
	// When you automatically enable new controls, you can interact with the controls
	// in the console and programmatically immediately after release. However,
	// automatically enabled controls have a temporary default status of DISABLED . It
	// can take up to several days for Security Hub to process the control release and
	// designate the control as ENABLED in your account. During the processing period,
	// you can manually enable or disable a control, and Security Hub will maintain
	// that designation regardless of whether you have AutoEnableControls set to true .
	AutoEnableControls *bool

	// Updates whether the calling account has consolidated control findings turned
	// on. If the value for this field is set to SECURITY_CONTROL , Security Hub
	// generates a single finding for a control check even when the check applies to
	// multiple enabled standards.
	//
	// If the value for this field is set to STANDARD_CONTROL , Security Hub generates
	// separate findings for a control check when the check applies to multiple enabled
	// standards.
	//
	// For accounts that are part of an organization, this value can only be updated
	// in the administrator account.
	ControlFindingGenerator types.ControlFindingGenerator

	noSmithyDocumentSerde
}

type UpdateSecurityHubConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateSecurityHubConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateSecurityHubConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateSecurityHubConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateSecurityHubConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateSecurityHubConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateSecurityHubConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateSecurityHubConfiguration",
	}
}
