// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all findings-generating solutions (products) that you are subscribed to
// receive findings from in Security Hub.
func (c *Client) ListEnabledProductsForImport(ctx context.Context, params *ListEnabledProductsForImportInput, optFns ...func(*Options)) (*ListEnabledProductsForImportOutput, error) {
	if params == nil {
		params = &ListEnabledProductsForImportInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListEnabledProductsForImport", params, optFns, c.addOperationListEnabledProductsForImportMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListEnabledProductsForImportOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListEnabledProductsForImportInput struct {

	// The maximum number of items to return in the response.
	MaxResults *int32

	// The token that is required for pagination. On your first call to the
	// ListEnabledProductsForImport operation, set the value of this parameter to NULL .
	//
	// For subsequent calls to the operation, to continue listing data, set the value
	// of this parameter to the value returned from the previous response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListEnabledProductsForImportOutput struct {

	// The pagination token to use to request the next page of results.
	NextToken *string

	// The list of ARNs for the resources that represent your subscriptions to
	// products.
	ProductSubscriptions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListEnabledProductsForImportMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListEnabledProductsForImport{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListEnabledProductsForImport{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListEnabledProductsForImport"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListEnabledProductsForImport(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListEnabledProductsForImportPaginatorOptions is the paginator options for
// ListEnabledProductsForImport
type ListEnabledProductsForImportPaginatorOptions struct {
	// The maximum number of items to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListEnabledProductsForImportPaginator is a paginator for
// ListEnabledProductsForImport
type ListEnabledProductsForImportPaginator struct {
	options   ListEnabledProductsForImportPaginatorOptions
	client    ListEnabledProductsForImportAPIClient
	params    *ListEnabledProductsForImportInput
	nextToken *string
	firstPage bool
}

// NewListEnabledProductsForImportPaginator returns a new
// ListEnabledProductsForImportPaginator
func NewListEnabledProductsForImportPaginator(client ListEnabledProductsForImportAPIClient, params *ListEnabledProductsForImportInput, optFns ...func(*ListEnabledProductsForImportPaginatorOptions)) *ListEnabledProductsForImportPaginator {
	if params == nil {
		params = &ListEnabledProductsForImportInput{}
	}

	options := ListEnabledProductsForImportPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListEnabledProductsForImportPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListEnabledProductsForImportPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListEnabledProductsForImport page.
func (p *ListEnabledProductsForImportPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListEnabledProductsForImportOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListEnabledProductsForImport(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListEnabledProductsForImportAPIClient is a client that implements the
// ListEnabledProductsForImport operation.
type ListEnabledProductsForImportAPIClient interface {
	ListEnabledProductsForImport(context.Context, *ListEnabledProductsForImportInput, ...func(*Options)) (*ListEnabledProductsForImportOutput, error)
}

var _ ListEnabledProductsForImportAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListEnabledProductsForImport(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListEnabledProductsForImport",
	}
}
