// Code generated by smithy-go-codegen DO NOT EDIT.

package securityhub

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/securityhub/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Used by customers to update information about their investigation into a
// finding. Requested by delegated administrator accounts or member accounts.
// Delegated administrator accounts can update findings for their account and their
// member accounts. Member accounts can update findings for their account.
// BatchUpdateFindings and BatchUpdateFindingV2 both use
// securityhub:BatchUpdateFindings in the Action element of an IAM policy
// statement. You must have permission to perform the
// securityhub:BatchUpdateFindings action. Updates from BatchUpdateFindingsV2
// don't affect the value of f inding_info.modified_time ,
// finding_info.modified_time_dt , time , time_dt for a finding .
func (c *Client) BatchUpdateFindingsV2(ctx context.Context, params *BatchUpdateFindingsV2Input, optFns ...func(*Options)) (*BatchUpdateFindingsV2Output, error) {
	if params == nil {
		params = &BatchUpdateFindingsV2Input{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchUpdateFindingsV2", params, optFns, c.addOperationBatchUpdateFindingsV2Middlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchUpdateFindingsV2Output)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchUpdateFindingsV2Input struct {

	// The updated value for a user provided comment about the finding. Minimum
	// character length 1. Maximum character length 512.
	Comment *string

	// Provides information to identify a specific V2 finding.
	FindingIdentifiers []types.OcsfFindingIdentifier

	// The list of finding metadata.uid to indicate findings to update. Finding
	// metadata.uid is a globally unique identifier associated with the finding.
	// Customers cannot use MetadataUids together with FindingIdentifiers .
	MetadataUids []string

	// The updated value for the normalized severity identifier. The severity ID is an
	// integer with the allowed enum values [0, 1, 2, 3, 4, 5, 99]. When customer
	// provides the updated severity ID, the string sibling severity will automatically
	// be updated in the finding.
	SeverityId *int32

	// The updated value for the normalized status identifier. The status ID is an
	// integer with the allowed enum values [0, 1, 2, 3, 4, 5, 6, 99]. When customer
	// provides the updated status ID, the string sibling status will automatically be
	// updated in the finding.
	StatusId *int32

	noSmithyDocumentSerde
}

type BatchUpdateFindingsV2Output struct {

	// The list of findings that were updated successfully.
	//
	// This member is required.
	ProcessedFindings []types.BatchUpdateFindingsV2ProcessedFinding

	// The list of V2 findings that were not updated.
	//
	// This member is required.
	UnprocessedFindings []types.BatchUpdateFindingsV2UnprocessedFinding

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchUpdateFindingsV2Middlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchUpdateFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchUpdateFindingsV2{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchUpdateFindingsV2"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpBatchUpdateFindingsV2ValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchUpdateFindingsV2(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchUpdateFindingsV2(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchUpdateFindingsV2",
	}
}
