// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an MLflow App.
func (c *Client) UpdateMlflowApp(ctx context.Context, params *UpdateMlflowAppInput, optFns ...func(*Options)) (*UpdateMlflowAppOutput, error) {
	if params == nil {
		params = &UpdateMlflowAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateMlflowApp", params, optFns, c.addOperationUpdateMlflowAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateMlflowAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateMlflowAppInput struct {

	// The ARN of the MLflow App to update.
	//
	// This member is required.
	Arn *string

	// Indicates whether this this MLflow App is the default for the account.
	AccountDefaultStatus types.AccountDefaultStatus

	// The new S3 URI for the general purpose bucket to use as the artifact store for
	// the MLflow App.
	ArtifactStoreUri *string

	// List of SageMaker Domain IDs for which this MLflow App is the default.
	DefaultDomainIdList []string

	// Whether to enable or disable automatic registration of new MLflow models to the
	// SageMaker Model Registry. To enable automatic model registration, set this value
	// to AutoModelRegistrationEnabled . To disable automatic model registration, set
	// this value to AutoModelRegistrationDisabled . If not specified,
	// AutomaticModelRegistration defaults to AutoModelRegistrationEnabled
	ModelRegistrationMode types.ModelRegistrationMode

	// The name of the MLflow App to update.
	Name *string

	// The new weekly maintenance window start day and time to update. The maintenance
	// window day and time should be in Coordinated Universal Time (UTC) 24-hour
	// standard time. For example: TUE:03:30.
	WeeklyMaintenanceWindowStart *string

	noSmithyDocumentSerde
}

type UpdateMlflowAppOutput struct {

	// The ARN of the updated MLflow App.
	Arn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateMlflowAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateMlflowApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateMlflowApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateMlflowAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateMlflowApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateMlflowApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateMlflowApp",
	}
}
