// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves a list of training plans for the current account.
func (c *Client) ListTrainingPlans(ctx context.Context, params *ListTrainingPlansInput, optFns ...func(*Options)) (*ListTrainingPlansOutput, error) {
	if params == nil {
		params = &ListTrainingPlansInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTrainingPlans", params, optFns, c.addOperationListTrainingPlansMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTrainingPlansOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListTrainingPlansInput struct {

	// Additional filters to apply to the list of training plans.
	Filters []types.TrainingPlanFilter

	// The maximum number of results to return in the response.
	MaxResults *int32

	// A token to continue pagination if more results are available.
	NextToken *string

	// The training plan field to sort the results by (e.g., StartTime, Status).
	SortBy types.TrainingPlanSortBy

	// The order to sort the results (Ascending or Descending).
	SortOrder types.TrainingPlanSortOrder

	// Filter to list only training plans with an actual start time after this date.
	StartTimeAfter *time.Time

	// Filter to list only training plans with an actual start time before this date.
	StartTimeBefore *time.Time

	noSmithyDocumentSerde
}

type ListTrainingPlansOutput struct {

	// A list of summary information for the training plans.
	//
	// This member is required.
	TrainingPlanSummaries []types.TrainingPlanSummary

	// A token to continue pagination if more results are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTrainingPlansMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListTrainingPlans{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListTrainingPlans{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTrainingPlans"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListTrainingPlansValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTrainingPlans(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListTrainingPlansPaginatorOptions is the paginator options for ListTrainingPlans
type ListTrainingPlansPaginatorOptions struct {
	// The maximum number of results to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTrainingPlansPaginator is a paginator for ListTrainingPlans
type ListTrainingPlansPaginator struct {
	options   ListTrainingPlansPaginatorOptions
	client    ListTrainingPlansAPIClient
	params    *ListTrainingPlansInput
	nextToken *string
	firstPage bool
}

// NewListTrainingPlansPaginator returns a new ListTrainingPlansPaginator
func NewListTrainingPlansPaginator(client ListTrainingPlansAPIClient, params *ListTrainingPlansInput, optFns ...func(*ListTrainingPlansPaginatorOptions)) *ListTrainingPlansPaginator {
	if params == nil {
		params = &ListTrainingPlansInput{}
	}

	options := ListTrainingPlansPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTrainingPlansPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTrainingPlansPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTrainingPlans page.
func (p *ListTrainingPlansPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTrainingPlansOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTrainingPlans(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTrainingPlansAPIClient is a client that implements the ListTrainingPlans
// operation.
type ListTrainingPlansAPIClient interface {
	ListTrainingPlans(context.Context, *ListTrainingPlansInput, ...func(*Options)) (*ListTrainingPlansOutput, error)
}

var _ ListTrainingPlansAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTrainingPlans(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTrainingPlans",
	}
}
