// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets a list of all versions of the pipeline.
func (c *Client) ListPipelineVersions(ctx context.Context, params *ListPipelineVersionsInput, optFns ...func(*Options)) (*ListPipelineVersionsOutput, error) {
	if params == nil {
		params = &ListPipelineVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListPipelineVersions", params, optFns, c.addOperationListPipelineVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListPipelineVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListPipelineVersionsInput struct {

	// The Amazon Resource Name (ARN) of the pipeline.
	//
	// This member is required.
	PipelineName *string

	// A filter that returns the pipeline versions that were created after a specified
	// time.
	CreatedAfter *time.Time

	// A filter that returns the pipeline versions that were created before a
	// specified time.
	CreatedBefore *time.Time

	// The maximum number of pipeline versions to return in the response.
	MaxResults *int32

	// If the result of the previous ListPipelineVersions request was truncated, the
	// response includes a NextToken . To retrieve the next set of pipeline versions,
	// use this token in your next request.
	NextToken *string

	// The sort order for the results.
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListPipelineVersionsOutput struct {

	// If the result of the previous ListPipelineVersions request was truncated, the
	// response includes a NextToken . To retrieve the next set of pipeline versions,
	// use this token in your next request.
	NextToken *string

	// Contains a sorted list of pipeline version summary objects matching the
	// specified filters. Each version summary includes the pipeline version ID, the
	// creation date, and the last pipeline execution created from that version. This
	// list can be empty.
	PipelineVersionSummaries []types.PipelineVersionSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListPipelineVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListPipelineVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListPipelineVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListPipelineVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListPipelineVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListPipelineVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListPipelineVersionsPaginatorOptions is the paginator options for
// ListPipelineVersions
type ListPipelineVersionsPaginatorOptions struct {
	// The maximum number of pipeline versions to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListPipelineVersionsPaginator is a paginator for ListPipelineVersions
type ListPipelineVersionsPaginator struct {
	options   ListPipelineVersionsPaginatorOptions
	client    ListPipelineVersionsAPIClient
	params    *ListPipelineVersionsInput
	nextToken *string
	firstPage bool
}

// NewListPipelineVersionsPaginator returns a new ListPipelineVersionsPaginator
func NewListPipelineVersionsPaginator(client ListPipelineVersionsAPIClient, params *ListPipelineVersionsInput, optFns ...func(*ListPipelineVersionsPaginatorOptions)) *ListPipelineVersionsPaginator {
	if params == nil {
		params = &ListPipelineVersionsInput{}
	}

	options := ListPipelineVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListPipelineVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListPipelineVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListPipelineVersions page.
func (p *ListPipelineVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListPipelineVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListPipelineVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListPipelineVersionsAPIClient is a client that implements the
// ListPipelineVersions operation.
type ListPipelineVersionsAPIClient interface {
	ListPipelineVersions(context.Context, *ListPipelineVersionsInput, ...func(*Options)) (*ListPipelineVersionsOutput, error)
}

var _ ListPipelineVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListPipelineVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListPipelineVersions",
	}
}
