// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the list of instances (also called nodes interchangeably) in a
// SageMaker HyperPod cluster.
func (c *Client) ListClusterNodes(ctx context.Context, params *ListClusterNodesInput, optFns ...func(*Options)) (*ListClusterNodesOutput, error) {
	if params == nil {
		params = &ListClusterNodesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListClusterNodes", params, optFns, c.addOperationListClusterNodesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListClusterNodesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListClusterNodesInput struct {

	// The string name or the Amazon Resource Name (ARN) of the SageMaker HyperPod
	// cluster in which you want to retrieve the list of nodes.
	//
	// This member is required.
	ClusterName *string

	// A filter that returns nodes in a SageMaker HyperPod cluster created after the
	// specified time. Timestamps are formatted according to the ISO 8601 standard.
	//
	// Acceptable formats include:
	//
	//   - YYYY-MM-DDThh:mm:ss.sssTZD (UTC), for example, 2014-10-01T20:30:00.000Z
	//
	//   - YYYY-MM-DDThh:mm:ss.sssTZD (with offset), for example,
	//   2014-10-01T12:30:00.000-08:00
	//
	//   - YYYY-MM-DD , for example, 2014-10-01
	//
	//   - Unix time in seconds, for example, 1412195400 . This is also referred to as
	//   Unix Epoch time and represents the number of seconds since midnight, January 1,
	//   1970 UTC.
	//
	// For more information about the timestamp format, see [Timestamp] in the Amazon Web
	// Services Command Line Interface User Guide.
	//
	// [Timestamp]: https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp
	CreationTimeAfter *time.Time

	// A filter that returns nodes in a SageMaker HyperPod cluster created before the
	// specified time. The acceptable formats are the same as the timestamp formats for
	// CreationTimeAfter . For more information about the timestamp format, see [Timestamp] in
	// the Amazon Web Services Command Line Interface User Guide.
	//
	// [Timestamp]: https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-parameters-types.html#parameter-type-timestamp
	CreationTimeBefore *time.Time

	// Specifies whether to include nodes that are still being provisioned in the
	// response. When set to true, the response includes all nodes regardless of their
	// provisioning status. When set to False (default), only nodes with assigned
	// InstanceIds are returned.
	IncludeNodeLogicalIds *bool

	// A filter that returns the instance groups whose name contain a specified string.
	InstanceGroupNameContains *string

	// The maximum number of nodes to return in the response.
	MaxResults *int32

	// If the result of the previous ListClusterNodes request was truncated, the
	// response includes a NextToken . To retrieve the next set of cluster nodes, use
	// the token in the next request.
	NextToken *string

	// The field by which to sort results. The default value is CREATION_TIME .
	SortBy types.ClusterSortBy

	// The sort order for results. The default value is Ascending .
	SortOrder types.SortOrder

	noSmithyDocumentSerde
}

type ListClusterNodesOutput struct {

	// The summaries of listed instances in a SageMaker HyperPod cluster
	//
	// This member is required.
	ClusterNodeSummaries []types.ClusterNodeSummary

	// The next token specified for listing instances in a SageMaker HyperPod cluster.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListClusterNodesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListClusterNodes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListClusterNodes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListClusterNodesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListClusterNodes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListClusterNodesPaginatorOptions is the paginator options for ListClusterNodes
type ListClusterNodesPaginatorOptions struct {
	// The maximum number of nodes to return in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListClusterNodesPaginator is a paginator for ListClusterNodes
type ListClusterNodesPaginator struct {
	options   ListClusterNodesPaginatorOptions
	client    ListClusterNodesAPIClient
	params    *ListClusterNodesInput
	nextToken *string
	firstPage bool
}

// NewListClusterNodesPaginator returns a new ListClusterNodesPaginator
func NewListClusterNodesPaginator(client ListClusterNodesAPIClient, params *ListClusterNodesInput, optFns ...func(*ListClusterNodesPaginatorOptions)) *ListClusterNodesPaginator {
	if params == nil {
		params = &ListClusterNodesInput{}
	}

	options := ListClusterNodesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListClusterNodesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListClusterNodesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListClusterNodes page.
func (p *ListClusterNodesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListClusterNodesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListClusterNodes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListClusterNodesAPIClient is a client that implements the ListClusterNodes
// operation.
type ListClusterNodesAPIClient interface {
	ListClusterNodes(context.Context, *ListClusterNodesInput, ...func(*Options)) (*ListClusterNodesOutput, error)
}

var _ ListClusterNodesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListClusterNodes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListClusterNodes",
	}
}
