// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details about a reserved capacity.
func (c *Client) DescribeReservedCapacity(ctx context.Context, params *DescribeReservedCapacityInput, optFns ...func(*Options)) (*DescribeReservedCapacityOutput, error) {
	if params == nil {
		params = &DescribeReservedCapacityInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeReservedCapacity", params, optFns, c.addOperationDescribeReservedCapacityMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeReservedCapacityOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeReservedCapacityInput struct {

	// ARN of the reserved capacity to describe.
	//
	// This member is required.
	ReservedCapacityArn *string

	noSmithyDocumentSerde
}

type DescribeReservedCapacityOutput struct {

	// The Amazon EC2 instance type used in the reserved capacity.
	//
	// This member is required.
	InstanceType types.ReservedCapacityInstanceType

	// ARN of the reserved capacity.
	//
	// This member is required.
	ReservedCapacityArn *string

	// The total number of instances allocated to this reserved capacity.
	//
	// This member is required.
	TotalInstanceCount *int32

	// The Availability Zone where the reserved capacity is provisioned.
	AvailabilityZone *string

	// The number of instances currently available for use in this reserved capacity.
	AvailableInstanceCount *int32

	// The total duration of the reserved capacity in hours.
	DurationHours *int64

	// The number of minutes for the duration of the reserved capacity. For example,
	// if a reserved capacity starts at 08:55 and ends at 11:30, the minutes field
	// would be 35.
	DurationMinutes *int64

	// The timestamp when the reserved capacity expires.
	EndTime *time.Time

	// The number of instances currently in use from this reserved capacity.
	InUseInstanceCount *int32

	// The type of reserved capacity.
	ReservedCapacityType types.ReservedCapacityType

	// The timestamp when the reserved capacity becomes active.
	StartTime *time.Time

	// The current status of the reserved capacity.
	Status types.ReservedCapacityStatus

	// A summary of the UltraServer associated with this reserved capacity.
	UltraServerSummary *types.UltraServerSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeReservedCapacityMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeReservedCapacity{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeReservedCapacity{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeReservedCapacity"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeReservedCapacityValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeReservedCapacity(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeReservedCapacity(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeReservedCapacity",
	}
}
