// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets information about a SageMaker Partner AI App.
func (c *Client) DescribePartnerApp(ctx context.Context, params *DescribePartnerAppInput, optFns ...func(*Options)) (*DescribePartnerAppOutput, error) {
	if params == nil {
		params = &DescribePartnerAppInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribePartnerApp", params, optFns, c.addOperationDescribePartnerAppMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribePartnerAppOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribePartnerAppInput struct {

	// The ARN of the SageMaker Partner AI App to describe.
	//
	// This member is required.
	Arn *string

	// When set to TRUE , the response includes available upgrade information for the
	// SageMaker Partner AI App. Default is FALSE .
	IncludeAvailableUpgrade *bool

	noSmithyDocumentSerde
}

type DescribePartnerAppOutput struct {

	// Configuration settings for the SageMaker Partner AI App.
	ApplicationConfig *types.PartnerAppConfig

	// The ARN of the SageMaker Partner AI App that was described.
	Arn *string

	// The authorization type that users use to access the SageMaker Partner AI App.
	AuthType types.PartnerAppAuthType

	// A map of available minor version upgrades for the SageMaker Partner AI App. The
	// key is the semantic version number, and the value is a list of release notes for
	// that version. A null value indicates no upgrades are available.
	AvailableUpgrade *types.AvailableUpgrade

	// The URL of the SageMaker Partner AI App that the Application SDK uses to
	// support in-app calls for the user.
	BaseUrl *string

	// The time that the SageMaker Partner AI App was created.
	CreationTime *time.Time

	// The end-of-life date for the current version of the SageMaker Partner AI App.
	CurrentVersionEolDate *time.Time

	// Indicates whether the SageMaker Partner AI App is configured for automatic
	// minor version upgrades during scheduled maintenance windows.
	EnableAutoMinorVersionUpgrade *bool

	// When set to TRUE , the SageMaker Partner AI App sets the Amazon Web Services IAM
	// session name or the authenticated IAM user as the identity of the SageMaker
	// Partner AI App user.
	EnableIamSessionBasedIdentity *bool

	// This is an error field object that contains the error code and the reason for
	// an operation failure.
	Error *types.ErrorInfo

	// The ARN of the IAM role associated with the SageMaker Partner AI App.
	ExecutionRoleArn *string

	// The Amazon Web Services KMS customer managed key used to encrypt the data at
	// rest associated with SageMaker Partner AI Apps.
	KmsKeyId *string

	// The time that the SageMaker Partner AI App was last modified.
	LastModifiedTime *time.Time

	// Maintenance configuration settings for the SageMaker Partner AI App.
	MaintenanceConfig *types.PartnerAppMaintenanceConfig

	// The name of the SageMaker Partner AI App.
	Name *string

	// The status of the SageMaker Partner AI App.
	//
	//   - Creating: SageMaker AI is creating the partner AI app. The partner AI app
	//   is not available during creation.
	//
	//   - Updating: SageMaker AI is updating the partner AI app. The partner AI app
	//   is not available when updating.
	//
	//   - Deleting: SageMaker AI is deleting the partner AI app. The partner AI app
	//   is not available during deletion.
	//
	//   - Available: The partner AI app is provisioned and accessible.
	//
	//   - Failed: The partner AI app is in a failed state and isn't available.
	//   SageMaker AI is investigating the issue. For further guidance, contact Amazon
	//   Web Services Support.
	//
	//   - UpdateFailed: The partner AI app couldn't be updated but is available.
	//
	//   - Deleted: The partner AI app is permanently deleted and not available.
	Status types.PartnerAppStatus

	// The instance type and size of the cluster attached to the SageMaker Partner AI
	// App.
	Tier *string

	// The type of SageMaker Partner AI App. Must be one of the following: lakera-guard
	// , comet , deepchecks-llm-evaluation , or fiddler .
	Type types.PartnerAppType

	// The version of the SageMaker Partner AI App.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribePartnerAppMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribePartnerApp{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribePartnerApp"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribePartnerAppValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribePartnerApp(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribePartnerApp(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribePartnerApp",
	}
}
