// Code generated by smithy-go-codegen DO NOT EDIT.

package s3vectors

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/document"
	"github.com/aws/aws-sdk-go-v2/service/s3vectors/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Performs an approximate nearest neighbor search query in a vector index using a
// query vector. By default, it returns the keys of approximate nearest neighbors.
// You can optionally include the computed distance (between the query vector and
// each vector in the response), the vector data, and metadata of each vector in
// the response.
//
// To specify the vector index, you can either use both the vector bucket name and
// the vector index name, or use the vector index Amazon Resource Name (ARN).
//
// Permissions You must have the s3vectors:QueryVectors permission to use this
// operation. Additional permissions are required based on the request parameters
// you specify:
//
//   - With only s3vectors:QueryVectors permission, you can retrieve vector keys of
//     approximate nearest neighbors and computed distances between these vectors. This
//     permission is sufficient only when you don't set any metadata filters and don't
//     request vector data or metadata (by keeping the returnMetadata parameter set
//     to false or not specified).
//
//   - If you specify a metadata filter or set returnMetadata to true, you must
//     have both s3vectors:QueryVectors and s3vectors:GetVectors permissions. The
//     request fails with a 403 Forbidden error if you request metadata filtering,
//     vector data, or metadata without the s3vectors:GetVectors permission.
func (c *Client) QueryVectors(ctx context.Context, params *QueryVectorsInput, optFns ...func(*Options)) (*QueryVectorsOutput, error) {
	if params == nil {
		params = &QueryVectorsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "QueryVectors", params, optFns, c.addOperationQueryVectorsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*QueryVectorsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type QueryVectorsInput struct {

	// The query vector. Ensure that the query vector has the same dimension as the
	// dimension of the vector index that's being queried. For example, if your vector
	// index contains vectors with 384 dimensions, your query vector must also have 384
	// dimensions.
	//
	// This member is required.
	QueryVector types.VectorData

	// The number of results to return for each query.
	//
	// This member is required.
	TopK *int32

	// Metadata filter to apply during the query. For more information about metadata
	// keys, see [Metadata filtering]in the Amazon S3 User Guide.
	//
	// [Metadata filtering]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-vectors-metadata-filtering.html
	Filter document.Interface

	// The ARN of the vector index that you want to query.
	IndexArn *string

	// The name of the vector index that you want to query.
	IndexName *string

	// Indicates whether to include the computed distance in the response. The default
	// value is false .
	ReturnDistance bool

	// Indicates whether to include metadata in the response. The default value is
	// false .
	ReturnMetadata bool

	// The name of the vector bucket that contains the vector index.
	VectorBucketName *string

	noSmithyDocumentSerde
}

type QueryVectorsOutput struct {

	// The distance metric that was used for the similarity search calculation. This
	// is the same distance metric that was configured for the vector index when it was
	// created.
	//
	// This member is required.
	DistanceMetric types.DistanceMetric

	// The vectors in the approximate nearest neighbor search.
	//
	// This member is required.
	Vectors []types.QueryOutputVector

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationQueryVectorsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpQueryVectors{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpQueryVectors{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "QueryVectors"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpQueryVectorsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opQueryVectors(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opQueryVectors(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "QueryVectors",
	}
}
