// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateNamespace struct {
}

func (*validateOpCreateNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTableBucket struct {
}

func (*validateOpCreateTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTable struct {
}

func (*validateOpCreateTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteNamespace struct {
}

func (*validateOpDeleteNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketEncryption struct {
}

func (*validateOpDeleteTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucket struct {
}

func (*validateOpDeleteTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketMetricsConfiguration struct {
}

func (*validateOpDeleteTableBucketMetricsConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketMetricsConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketMetricsConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketMetricsConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketPolicy struct {
}

func (*validateOpDeleteTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableBucketReplication struct {
}

func (*validateOpDeleteTableBucketReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableBucketReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableBucketReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableBucketReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTable struct {
}

func (*validateOpDeleteTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTablePolicy struct {
}

func (*validateOpDeleteTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTableReplication struct {
}

func (*validateOpDeleteTableReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTableReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetNamespace struct {
}

func (*validateOpGetNamespace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetNamespace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetNamespaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetNamespaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketEncryption struct {
}

func (*validateOpGetTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucket struct {
}

func (*validateOpGetTableBucket) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucket) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketMaintenanceConfiguration struct {
}

func (*validateOpGetTableBucketMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketMetricsConfiguration struct {
}

func (*validateOpGetTableBucketMetricsConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketMetricsConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketMetricsConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketMetricsConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketPolicy struct {
}

func (*validateOpGetTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketReplication struct {
}

func (*validateOpGetTableBucketReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableBucketStorageClass struct {
}

func (*validateOpGetTableBucketStorageClass) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableBucketStorageClass) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableBucketStorageClassInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableBucketStorageClassInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableEncryption struct {
}

func (*validateOpGetTableEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMaintenanceConfiguration struct {
}

func (*validateOpGetTableMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMaintenanceJobStatus struct {
}

func (*validateOpGetTableMaintenanceJobStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMaintenanceJobStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMaintenanceJobStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMaintenanceJobStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableMetadataLocation struct {
}

func (*validateOpGetTableMetadataLocation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableMetadataLocation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableMetadataLocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableMetadataLocationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTablePolicy struct {
}

func (*validateOpGetTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableRecordExpirationConfiguration struct {
}

func (*validateOpGetTableRecordExpirationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableRecordExpirationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableRecordExpirationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableRecordExpirationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableRecordExpirationJobStatus struct {
}

func (*validateOpGetTableRecordExpirationJobStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableRecordExpirationJobStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableRecordExpirationJobStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableRecordExpirationJobStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableReplication struct {
}

func (*validateOpGetTableReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableReplicationStatus struct {
}

func (*validateOpGetTableReplicationStatus) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableReplicationStatus) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableReplicationStatusInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableReplicationStatusInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTableStorageClass struct {
}

func (*validateOpGetTableStorageClass) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTableStorageClass) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableStorageClassInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableStorageClassInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListNamespaces struct {
}

func (*validateOpListNamespaces) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListNamespaces) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListNamespacesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListNamespacesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTables struct {
}

func (*validateOpListTables) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTables) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTablesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTablesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketEncryption struct {
}

func (*validateOpPutTableBucketEncryption) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketEncryption) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketEncryptionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketEncryptionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketMaintenanceConfiguration struct {
}

func (*validateOpPutTableBucketMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketMetricsConfiguration struct {
}

func (*validateOpPutTableBucketMetricsConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketMetricsConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketMetricsConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketMetricsConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketPolicy struct {
}

func (*validateOpPutTableBucketPolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketPolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketPolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketPolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketReplication struct {
}

func (*validateOpPutTableBucketReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableBucketStorageClass struct {
}

func (*validateOpPutTableBucketStorageClass) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableBucketStorageClass) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableBucketStorageClassInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableBucketStorageClassInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableMaintenanceConfiguration struct {
}

func (*validateOpPutTableMaintenanceConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableMaintenanceConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableMaintenanceConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableMaintenanceConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTablePolicy struct {
}

func (*validateOpPutTablePolicy) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTablePolicy) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTablePolicyInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTablePolicyInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableRecordExpirationConfiguration struct {
}

func (*validateOpPutTableRecordExpirationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableRecordExpirationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableRecordExpirationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableRecordExpirationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTableReplication struct {
}

func (*validateOpPutTableReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTableReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTableReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTableReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRenameTable struct {
}

func (*validateOpRenameTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRenameTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RenameTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRenameTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateTableMetadataLocation struct {
}

func (*validateOpUpdateTableMetadataLocation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateTableMetadataLocation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateTableMetadataLocationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateTableMetadataLocationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateNamespace{}, middleware.After)
}

func addOpCreateTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTableBucket{}, middleware.After)
}

func addOpCreateTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTable{}, middleware.After)
}

func addOpDeleteNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteNamespace{}, middleware.After)
}

func addOpDeleteTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketEncryption{}, middleware.After)
}

func addOpDeleteTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucket{}, middleware.After)
}

func addOpDeleteTableBucketMetricsConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketMetricsConfiguration{}, middleware.After)
}

func addOpDeleteTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketPolicy{}, middleware.After)
}

func addOpDeleteTableBucketReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableBucketReplication{}, middleware.After)
}

func addOpDeleteTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTable{}, middleware.After)
}

func addOpDeleteTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTablePolicy{}, middleware.After)
}

func addOpDeleteTableReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTableReplication{}, middleware.After)
}

func addOpGetNamespaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetNamespace{}, middleware.After)
}

func addOpGetTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketEncryption{}, middleware.After)
}

func addOpGetTableBucketValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucket{}, middleware.After)
}

func addOpGetTableBucketMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketMaintenanceConfiguration{}, middleware.After)
}

func addOpGetTableBucketMetricsConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketMetricsConfiguration{}, middleware.After)
}

func addOpGetTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketPolicy{}, middleware.After)
}

func addOpGetTableBucketReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketReplication{}, middleware.After)
}

func addOpGetTableBucketStorageClassValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableBucketStorageClass{}, middleware.After)
}

func addOpGetTableEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableEncryption{}, middleware.After)
}

func addOpGetTableMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMaintenanceConfiguration{}, middleware.After)
}

func addOpGetTableMaintenanceJobStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMaintenanceJobStatus{}, middleware.After)
}

func addOpGetTableMetadataLocationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableMetadataLocation{}, middleware.After)
}

func addOpGetTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTablePolicy{}, middleware.After)
}

func addOpGetTableRecordExpirationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableRecordExpirationConfiguration{}, middleware.After)
}

func addOpGetTableRecordExpirationJobStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableRecordExpirationJobStatus{}, middleware.After)
}

func addOpGetTableReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableReplication{}, middleware.After)
}

func addOpGetTableReplicationStatusValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableReplicationStatus{}, middleware.After)
}

func addOpGetTableStorageClassValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTableStorageClass{}, middleware.After)
}

func addOpListNamespacesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListNamespaces{}, middleware.After)
}

func addOpListTablesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTables{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpPutTableBucketEncryptionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketEncryption{}, middleware.After)
}

func addOpPutTableBucketMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketMaintenanceConfiguration{}, middleware.After)
}

func addOpPutTableBucketMetricsConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketMetricsConfiguration{}, middleware.After)
}

func addOpPutTableBucketPolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketPolicy{}, middleware.After)
}

func addOpPutTableBucketReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketReplication{}, middleware.After)
}

func addOpPutTableBucketStorageClassValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableBucketStorageClass{}, middleware.After)
}

func addOpPutTableMaintenanceConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableMaintenanceConfiguration{}, middleware.After)
}

func addOpPutTablePolicyValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTablePolicy{}, middleware.After)
}

func addOpPutTableRecordExpirationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableRecordExpirationConfiguration{}, middleware.After)
}

func addOpPutTableReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTableReplication{}, middleware.After)
}

func addOpRenameTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRenameTable{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateTableMetadataLocationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateTableMetadataLocation{}, middleware.After)
}

func validateEncryptionConfiguration(v *types.EncryptionConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionConfiguration"}
	if len(v.SseAlgorithm) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SseAlgorithm"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIcebergMetadata(v *types.IcebergMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IcebergMetadata"}
	if v.Schema == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Schema"))
	} else if v.Schema != nil {
		if err := validateIcebergSchema(v.Schema); err != nil {
			invalidParams.AddNested("Schema", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateIcebergSchema(v *types.IcebergSchema) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "IcebergSchema"}
	if v.Fields == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Fields"))
	} else if v.Fields != nil {
		if err := validateSchemaFieldList(v.Fields); err != nil {
			invalidParams.AddNested("Fields", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationDestination(v *types.ReplicationDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationDestination"}
	if v.DestinationTableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DestinationTableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateReplicationDestinations(v []types.ReplicationDestination) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReplicationDestinations"}
	for i := range v {
		if err := validateReplicationDestination(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaField(v *types.SchemaField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaField"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaFieldList(v []types.SchemaField) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaFieldList"}
	for i := range v {
		if err := validateSchemaField(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStorageClassConfiguration(v *types.StorageClassConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StorageClassConfiguration"}
	if len(v.StorageClass) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("StorageClass"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableBucketReplicationConfiguration(v *types.TableBucketReplicationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableBucketReplicationConfiguration"}
	if v.Role == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Role"))
	}
	if v.Rules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Rules"))
	} else if v.Rules != nil {
		if err := validateTableBucketReplicationRules(v.Rules); err != nil {
			invalidParams.AddNested("Rules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableBucketReplicationRule(v *types.TableBucketReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableBucketReplicationRule"}
	if v.Destinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destinations"))
	} else if v.Destinations != nil {
		if err := validateReplicationDestinations(v.Destinations); err != nil {
			invalidParams.AddNested("Destinations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableBucketReplicationRules(v []types.TableBucketReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableBucketReplicationRules"}
	for i := range v {
		if err := validateTableBucketReplicationRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableMetadata(v types.TableMetadata) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableMetadata"}
	switch uv := v.(type) {
	case *types.TableMetadataMemberIceberg:
		if err := validateIcebergMetadata(&uv.Value); err != nil {
			invalidParams.AddNested("[iceberg]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableReplicationConfiguration(v *types.TableReplicationConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableReplicationConfiguration"}
	if v.Role == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Role"))
	}
	if v.Rules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Rules"))
	} else if v.Rules != nil {
		if err := validateTableReplicationRules(v.Rules); err != nil {
			invalidParams.AddNested("Rules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableReplicationRule(v *types.TableReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableReplicationRule"}
	if v.Destinations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Destinations"))
	} else if v.Destinations != nil {
		if err := validateReplicationDestinations(v.Destinations); err != nil {
			invalidParams.AddNested("Destinations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTableReplicationRules(v []types.TableReplicationRule) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TableReplicationRules"}
	for i := range v {
		if err := validateTableReplicationRule(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateNamespaceInput(v *CreateNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTableBucketInput(v *CreateTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTableBucketInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageClassConfiguration != nil {
		if err := validateStorageClassConfiguration(v.StorageClassConfiguration); err != nil {
			invalidParams.AddNested("StorageClassConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTableInput(v *CreateTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Format) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Format"))
	}
	if v.Metadata != nil {
		if err := validateTableMetadata(v.Metadata); err != nil {
			invalidParams.AddNested("Metadata", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.StorageClassConfiguration != nil {
		if err := validateStorageClassConfiguration(v.StorageClassConfiguration); err != nil {
			invalidParams.AddNested("StorageClassConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteNamespaceInput(v *DeleteNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketEncryptionInput(v *DeleteTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketInput(v *DeleteTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketMetricsConfigurationInput(v *DeleteTableBucketMetricsConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketMetricsConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketPolicyInput(v *DeleteTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableBucketReplicationInput(v *DeleteTableBucketReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableBucketReplicationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableInput(v *DeleteTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTablePolicyInput(v *DeleteTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableReplicationInput(v *DeleteTableReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableReplicationInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if v.VersionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VersionToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetNamespaceInput(v *GetNamespaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetNamespaceInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketEncryptionInput(v *GetTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketInput(v *GetTableBucketInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketMaintenanceConfigurationInput(v *GetTableBucketMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketMetricsConfigurationInput(v *GetTableBucketMetricsConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketMetricsConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketPolicyInput(v *GetTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketReplicationInput(v *GetTableBucketReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketReplicationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableBucketStorageClassInput(v *GetTableBucketStorageClassInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableBucketStorageClassInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableEncryptionInput(v *GetTableEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMaintenanceConfigurationInput(v *GetTableMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMaintenanceJobStatusInput(v *GetTableMaintenanceJobStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMaintenanceJobStatusInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableMetadataLocationInput(v *GetTableMetadataLocationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableMetadataLocationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTablePolicyInput(v *GetTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableRecordExpirationConfigurationInput(v *GetTableRecordExpirationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableRecordExpirationConfigurationInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableRecordExpirationJobStatusInput(v *GetTableRecordExpirationJobStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableRecordExpirationJobStatusInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableReplicationInput(v *GetTableReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableReplicationInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableReplicationStatusInput(v *GetTableReplicationStatusInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableReplicationStatusInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableStorageClassInput(v *GetTableStorageClassInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableStorageClassInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListNamespacesInput(v *ListNamespacesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListNamespacesInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTablesInput(v *ListTablesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTablesInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketEncryptionInput(v *PutTableBucketEncryptionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketEncryptionInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.EncryptionConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EncryptionConfiguration"))
	} else if v.EncryptionConfiguration != nil {
		if err := validateEncryptionConfiguration(v.EncryptionConfiguration); err != nil {
			invalidParams.AddNested("EncryptionConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketMaintenanceConfigurationInput(v *PutTableBucketMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketMetricsConfigurationInput(v *PutTableBucketMetricsConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketMetricsConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketPolicyInput(v *PutTableBucketPolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketPolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.ResourcePolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourcePolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketReplicationInput(v *PutTableBucketReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketReplicationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Configuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configuration"))
	} else if v.Configuration != nil {
		if err := validateTableBucketReplicationConfiguration(v.Configuration); err != nil {
			invalidParams.AddNested("Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableBucketStorageClassInput(v *PutTableBucketStorageClassInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableBucketStorageClassInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.StorageClassConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageClassConfiguration"))
	} else if v.StorageClassConfiguration != nil {
		if err := validateStorageClassConfiguration(v.StorageClassConfiguration); err != nil {
			invalidParams.AddNested("StorageClassConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableMaintenanceConfigurationInput(v *PutTableMaintenanceConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableMaintenanceConfigurationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTablePolicyInput(v *PutTablePolicyInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTablePolicyInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ResourcePolicy == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourcePolicy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableRecordExpirationConfigurationInput(v *PutTableRecordExpirationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableRecordExpirationConfigurationInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTableReplicationInput(v *PutTableReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTableReplicationInput"}
	if v.TableArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableArn"))
	}
	if v.Configuration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Configuration"))
	} else if v.Configuration != nil {
		if err := validateTableReplicationConfiguration(v.Configuration); err != nil {
			invalidParams.AddNested("Configuration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRenameTableInput(v *RenameTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RenameTableInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateTableMetadataLocationInput(v *UpdateTableMetadataLocationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateTableMetadataLocationInput"}
	if v.TableBucketARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableBucketARN"))
	}
	if v.Namespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Namespace"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.VersionToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VersionToken"))
	}
	if v.MetadataLocation == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataLocation"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
