// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Configuration specifying how data should be encrypted. This structure defines
// the encryption algorithm and optional KMS key to be used for server-side
// encryption.
type EncryptionConfiguration struct {

	// The server-side encryption algorithm to use. Valid values are AES256 for
	// S3-managed encryption keys, or aws:kms for Amazon Web Services KMS-managed
	// encryption keys. If you choose SSE-KMS encryption you must grant the S3 Tables
	// maintenance principal access to your KMS key. For more information, see [Permissions requirements for S3 Tables SSE-KMS encryption].
	//
	// [Permissions requirements for S3 Tables SSE-KMS encryption]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html
	//
	// This member is required.
	SseAlgorithm SSEAlgorithm

	// The Amazon Resource Name (ARN) of the KMS key to use for encryption. This field
	// is required only when sseAlgorithm is set to aws:kms .
	KmsKeyArn *string

	noSmithyDocumentSerde
}

// Contains details about the compaction settings for an Iceberg table.
type IcebergCompactionSettings struct {

	// The compaction strategy to use for the table. This determines how files are
	// selected and combined during compaction operations.
	Strategy IcebergCompactionStrategy

	// The target file size for the table in MB.
	TargetFileSizeMB *int32

	noSmithyDocumentSerde
}

// Contains details about the metadata for an Iceberg table.
type IcebergMetadata struct {

	// The schema for an Iceberg table.
	//
	// This member is required.
	Schema *IcebergSchema

	// Contains configuration properties for an Iceberg table.
	Properties map[string]string

	noSmithyDocumentSerde
}

// Contains details about the schema for an Iceberg table.
type IcebergSchema struct {

	// The schema fields for the table
	//
	// This member is required.
	Fields []SchemaField

	noSmithyDocumentSerde
}

// Contains details about the snapshot management settings for an Iceberg table.
// The oldest snapshot expires when its age exceeds the maxSnapshotAgeHours and
// the total number of snapshots exceeds the value for the minimum number of
// snapshots to keep minSnapshotsToKeep .
type IcebergSnapshotManagementSettings struct {

	// The maximum age of a snapshot before it can be expired.
	MaxSnapshotAgeHours *int32

	// The minimum number of snapshots to keep.
	MinSnapshotsToKeep *int32

	noSmithyDocumentSerde
}

// Contains details about the unreferenced file removal settings for an Iceberg
// table bucket.
type IcebergUnreferencedFileRemovalSettings struct {

	// The number of days an object has to be non-current before it is deleted.
	NonCurrentDays *int32

	// The number of days an object has to be unreferenced before it is marked as
	// non-current.
	UnreferencedDays *int32

	noSmithyDocumentSerde
}

// Contains information about the most recent successful replication update to a
// destination.
type LastSuccessfulReplicatedUpdate struct {

	// The S3 location of the metadata that was successfully replicated.
	//
	// This member is required.
	MetadataLocation *string

	// The timestamp when the replication update completed successfully.
	//
	// This member is required.
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// Contains information about tables that are managed by S3 Tables, including
// replication information for replica tables.
type ManagedTableInformation struct {

	// If this table is a replica, contains information about the source table from
	// which it is replicated.
	ReplicationInformation *ReplicationInformation

	noSmithyDocumentSerde
}

// Contains details about a namespace.
type NamespaceSummary struct {

	// The date and time the namespace was created at.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the account that created the namespace.
	//
	// This member is required.
	CreatedBy *string

	// The name of the namespace.
	//
	// This member is required.
	Namespace []string

	// The ID of the account that owns the namespace.
	//
	// This member is required.
	OwnerAccountId *string

	// The system-assigned unique identifier for the namespace.
	NamespaceId *string

	// The system-assigned unique identifier for the table bucket that contains this
	// namespace.
	TableBucketId *string

	noSmithyDocumentSerde
}

// Specifies a destination table bucket for replication.
type ReplicationDestination struct {

	// The Amazon Resource Name (ARN) of the destination table bucket where tables
	// will be replicated.
	//
	// This member is required.
	DestinationTableBucketARN *string

	noSmithyDocumentSerde
}

// Contains status information for a replication destination, including the
// current replication state, last successful update, and any error messages.
type ReplicationDestinationStatusModel struct {

	// The Amazon Resource Name (ARN) of the destination table bucket.
	//
	// This member is required.
	DestinationTableBucketArn *string

	// The current status of replication to this destination.
	//
	// This member is required.
	ReplicationStatus ReplicationStatus

	// The Amazon Resource Name (ARN) of the destination table.
	DestinationTableArn *string

	// If replication has failed, this field contains an error message describing the
	// failure reason.
	FailureMessage *string

	// Information about the most recent successful replication update to this
	// destination.
	LastSuccessfulReplicatedUpdate *LastSuccessfulReplicatedUpdate

	noSmithyDocumentSerde
}

// Contains information about the source of a replicated table.
type ReplicationInformation struct {

	// The Amazon Resource Name (ARN) of the source table from which this table is
	// replicated.
	//
	// This member is required.
	SourceTableARN *string

	noSmithyDocumentSerde
}

// Contains details about a schema field.
type SchemaField struct {

	// The name of the field.
	//
	// This member is required.
	Name *string

	// The field type. S3 Tables supports all Apache Iceberg primitive types. For more
	// information, see the [Apache Iceberg documentation].
	//
	// [Apache Iceberg documentation]: https://iceberg.apache.org/spec/#primitive-types
	//
	// This member is required.
	Type *string

	// A Boolean value that specifies whether values are required for each row in this
	// field. By default, this is false and null values are allowed in the field. If
	// this is true the field does not allow null values.
	Required bool

	noSmithyDocumentSerde
}

// The configuration details for the storage class of tables or table buckets.
// This allows you to optimize storage costs by selecting the appropriate storage
// class based on your access patterns and performance requirements.
type StorageClassConfiguration struct {

	// The storage class for the table or table bucket. Valid values include storage
	// classes optimized for different access patterns and cost profiles.
	//
	// This member is required.
	StorageClass StorageClass

	noSmithyDocumentSerde
}

// Details about the values that define the maintenance configuration for a table
// bucket.
type TableBucketMaintenanceConfigurationValue struct {

	// Contains details about the settings of the maintenance configuration.
	Settings TableBucketMaintenanceSettings

	// The status of the maintenance configuration.
	Status MaintenanceStatus

	noSmithyDocumentSerde
}

// Contains details about the maintenance settings for the table bucket.
//
// The following types satisfy this interface:
//
//	TableBucketMaintenanceSettingsMemberIcebergUnreferencedFileRemoval
type TableBucketMaintenanceSettings interface {
	isTableBucketMaintenanceSettings()
}

// The unreferenced file removal settings for the table bucket.
type TableBucketMaintenanceSettingsMemberIcebergUnreferencedFileRemoval struct {
	Value IcebergUnreferencedFileRemovalSettings

	noSmithyDocumentSerde
}

func (*TableBucketMaintenanceSettingsMemberIcebergUnreferencedFileRemoval) isTableBucketMaintenanceSettings() {
}

// The replication configuration for a table bucket. This configuration defines
// how tables in the source bucket are replicated to destination table buckets,
// including the IAM role used for replication.
type TableBucketReplicationConfiguration struct {

	// The Amazon Resource Name (ARN) of the IAM role that S3 Tables assumes to
	// replicate tables on your behalf.
	//
	// This member is required.
	Role *string

	// An array of replication rules that define which tables to replicate and where
	// to replicate them.
	//
	// This member is required.
	Rules []TableBucketReplicationRule

	noSmithyDocumentSerde
}

// Defines a rule for replicating tables from a source table bucket to one or more
// destination table buckets.
type TableBucketReplicationRule struct {

	// An array of destination table buckets where tables should be replicated.
	//
	// This member is required.
	Destinations []ReplicationDestination

	noSmithyDocumentSerde
}

// Contains details about a table bucket.
type TableBucketSummary struct {

	// The Amazon Resource Name (ARN) of the table bucket.
	//
	// This member is required.
	Arn *string

	// The date and time the table bucket was created at.
	//
	// This member is required.
	CreatedAt *time.Time

	// The name of the table bucket.
	//
	// This member is required.
	Name *string

	// The ID of the account that owns the table bucket.
	//
	// This member is required.
	OwnerAccountId *string

	// The system-assigned unique identifier for the table bucket.
	TableBucketId *string

	// The type of the table bucket.
	Type TableBucketType

	noSmithyDocumentSerde
}

// The values that define a maintenance configuration for a table.
type TableMaintenanceConfigurationValue struct {

	// Contains details about the settings for the maintenance configuration.
	Settings TableMaintenanceSettings

	// The status of the maintenance configuration.
	Status MaintenanceStatus

	noSmithyDocumentSerde
}

// Details about the status of a maintenance job.
type TableMaintenanceJobStatusValue struct {

	// The status of the job.
	//
	// This member is required.
	Status JobStatus

	// The failure message of a failed job.
	FailureMessage *string

	// The date and time that the maintenance job was last run.
	LastRunTimestamp *time.Time

	noSmithyDocumentSerde
}

// Contains details about maintenance settings for the table.
//
// The following types satisfy this interface:
//
//	TableMaintenanceSettingsMemberIcebergCompaction
//	TableMaintenanceSettingsMemberIcebergSnapshotManagement
type TableMaintenanceSettings interface {
	isTableMaintenanceSettings()
}

// Contains details about the Iceberg compaction settings for the table.
type TableMaintenanceSettingsMemberIcebergCompaction struct {
	Value IcebergCompactionSettings

	noSmithyDocumentSerde
}

func (*TableMaintenanceSettingsMemberIcebergCompaction) isTableMaintenanceSettings() {}

// Contains details about the Iceberg snapshot management settings for the table.
type TableMaintenanceSettingsMemberIcebergSnapshotManagement struct {
	Value IcebergSnapshotManagementSettings

	noSmithyDocumentSerde
}

func (*TableMaintenanceSettingsMemberIcebergSnapshotManagement) isTableMaintenanceSettings() {}

// Contains details about the table metadata.
//
// The following types satisfy this interface:
//
//	TableMetadataMemberIceberg
type TableMetadata interface {
	isTableMetadata()
}

// Contains details about the metadata of an Iceberg table.
type TableMetadataMemberIceberg struct {
	Value IcebergMetadata

	noSmithyDocumentSerde
}

func (*TableMetadataMemberIceberg) isTableMetadata() {}

// The expiration configuration settings for records in a table, and the status of
// the configuration. If the status of the configuration is enabled, records expire
// and are automatically removed after the number of days specified in the record
// expiration settings for the table.
type TableRecordExpirationConfigurationValue struct {

	// The expiration settings for records in the table.
	Settings *TableRecordExpirationSettings

	// The status of the expiration settings for records in the table.
	Status TableRecordExpirationStatus

	noSmithyDocumentSerde
}

// Provides metrics for the record expiration job that most recently ran for a
// table. The metrics provide insight into the amount of data that was removed when
// the job ran.
type TableRecordExpirationJobMetrics struct {

	// The total number of data files that were removed when the job ran.
	DeletedDataFiles *int64

	// The total number of records that were removed when the job ran.
	DeletedRecords *int64

	// The total size (in bytes) of the data files that were removed when the job ran.
	RemovedFilesSize *int64

	noSmithyDocumentSerde
}

// The record expiration setting that specifies when records expire and are
// automatically removed from a table.
type TableRecordExpirationSettings struct {

	// If you enable record expiration for a table, you can specify the number of days
	// to retain your table records. For example, to retain your table records for one
	// year, set this value to 365 .
	Days *int32

	noSmithyDocumentSerde
}

// The replication configuration for an individual table. This configuration
// defines how the table is replicated to destination tables.
type TableReplicationConfiguration struct {

	// The Amazon Resource Name (ARN) of the IAM role that S3 Tables assumes to
	// replicate the table on your behalf.
	//
	// This member is required.
	Role *string

	// An array of replication rules that define where this table should be replicated.
	//
	// This member is required.
	Rules []TableReplicationRule

	noSmithyDocumentSerde
}

// Defines a rule for replicating a table to one or more destination tables.
type TableReplicationRule struct {

	// An array of destination table buckets where this table should be replicated.
	//
	// This member is required.
	Destinations []ReplicationDestination

	noSmithyDocumentSerde
}

// Contains details about a table.
type TableSummary struct {

	// The date and time the table was created at.
	//
	// This member is required.
	CreatedAt *time.Time

	// The date and time the table was last modified at.
	//
	// This member is required.
	ModifiedAt *time.Time

	// The name of the table.
	//
	// This member is required.
	Name *string

	// The name of the namespace.
	//
	// This member is required.
	Namespace []string

	// The Amazon Resource Name (ARN) of the table.
	//
	// This member is required.
	TableARN *string

	// The type of the table.
	//
	// This member is required.
	Type TableType

	// The Amazon Web Services service managing this table, if applicable. For
	// example, a replicated table is managed by the S3 Tables replication service.
	ManagedByService *string

	// The unique identifier for the namespace that contains this table.
	NamespaceId *string

	// The unique identifier for the table bucket that contains this table.
	TableBucketId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isTableBucketMaintenanceSettings() {}
func (*UnknownUnionMember) isTableMaintenanceSettings()       {}
func (*UnknownUnionMember) isTableMetadata()                  {}
