// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates or updates the replication configuration for a table bucket. This
// operation defines how tables in the source bucket are replicated to destination
// buckets. Replication helps ensure data availability and disaster recovery across
// regions or accounts.
//
// Permissions
//
//   - You must have the s3tables:PutTableBucketReplication permission to use this
//     operation. The IAM role specified in the configuration must have permissions to
//     read from the source bucket and write permissions to all destination buckets.
//
//   - You must also have the following permissions:
//
//   - s3tables:GetTable permission on the source table.
//
//   - s3tables:ListTables permission on the bucket containing the table.
//
//   - s3tables:CreateTable permission for the destination.
//
//   - s3tables:CreateNamespace permission for the destination.
//
//   - s3tables:GetTableMaintenanceConfig permission for the source bucket.
//
//   - s3tables:PutTableMaintenanceConfig permission for the destination bucket.
//
//   - You must have iam:PassRole permission with condition allowing roles to be
//     passed to replication.s3tables.amazonaws.com .
func (c *Client) PutTableBucketReplication(ctx context.Context, params *PutTableBucketReplicationInput, optFns ...func(*Options)) (*PutTableBucketReplicationOutput, error) {
	if params == nil {
		params = &PutTableBucketReplicationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "PutTableBucketReplication", params, optFns, c.addOperationPutTableBucketReplicationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*PutTableBucketReplicationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type PutTableBucketReplicationInput struct {

	// The replication configuration to apply, including the IAM role and replication
	// rules.
	//
	// This member is required.
	Configuration *types.TableBucketReplicationConfiguration

	// The Amazon Resource Name (ARN) of the source table bucket.
	//
	// This member is required.
	TableBucketARN *string

	// A version token from a previous GetTableBucketReplication call. Use this token
	// to ensure you're updating the expected version of the configuration.
	VersionToken *string

	noSmithyDocumentSerde
}

type PutTableBucketReplicationOutput struct {

	// The status of the replication configuration operation.
	//
	// This member is required.
	Status *string

	// A new version token representing the updated replication configuration.
	//
	// This member is required.
	VersionToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationPutTableBucketReplicationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpPutTableBucketReplication{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpPutTableBucketReplication{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "PutTableBucketReplication"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpPutTableBucketReplicationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opPutTableBucketReplication(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opPutTableBucketReplication(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "PutTableBucketReplication",
	}
}
