// Code generated by smithy-go-codegen DO NOT EDIT.

package s3tables

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/s3tables/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new table associated with the given namespace in a table bucket. For
// more information, see [Creating an Amazon S3 table]in the Amazon Simple Storage Service User Guide.
//
// Permissions
//
//   - You must have the s3tables:CreateTable permission to use this operation.
//
//   - If you use this operation with the optional metadata request parameter you
//     must have the s3tables:PutTableData permission.
//
//   - If you use this operation with the optional encryptionConfiguration request
//     parameter you must have the s3tables:PutTableEncryption permission.
//
//   - If you use this operation with the storageClassConfiguration request
//     parameter, you must have the s3tables:PutTableStorageClass permission.
//
//   - To create a table with tags, you must have the s3tables:TagResource
//     permission in addition to s3tables:CreateTable permission.
//
// Additionally, If you choose SSE-KMS encryption you must grant the S3 Tables
// maintenance principal access to your KMS key. For more information, see [Permissions requirements for S3 Tables SSE-KMS encryption].
//
// [Creating an Amazon S3 table]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-create.html
// [Permissions requirements for S3 Tables SSE-KMS encryption]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html
func (c *Client) CreateTable(ctx context.Context, params *CreateTableInput, optFns ...func(*Options)) (*CreateTableOutput, error) {
	if params == nil {
		params = &CreateTableInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateTable", params, optFns, c.addOperationCreateTableMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateTableOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateTableInput struct {

	// The format for the table.
	//
	// This member is required.
	Format types.OpenTableFormat

	// The name for the table.
	//
	// This member is required.
	Name *string

	// The namespace to associated with the table.
	//
	// This member is required.
	Namespace *string

	// The Amazon Resource Name (ARN) of the table bucket to create the table in.
	//
	// This member is required.
	TableBucketARN *string

	// The encryption configuration to use for the table. This configuration specifies
	// the encryption algorithm and, if using SSE-KMS, the KMS key to use for
	// encrypting the table.
	//
	// If you choose SSE-KMS encryption you must grant the S3 Tables maintenance
	// principal access to your KMS key. For more information, see [Permissions requirements for S3 Tables SSE-KMS encryption].
	//
	// [Permissions requirements for S3 Tables SSE-KMS encryption]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-kms-permissions.html
	EncryptionConfiguration *types.EncryptionConfiguration

	// The metadata for the table.
	Metadata types.TableMetadata

	// The storage class configuration for the table. If not specified, the table
	// inherits the storage class configuration from its table bucket. Specify this
	// parameter to override the bucket's default storage class for this table.
	StorageClassConfiguration *types.StorageClassConfiguration

	// A map of user-defined tags that you would like to apply to the table that you
	// are creating. A tag is a key-value pair that you apply to your resources. Tags
	// can help you organize, track costs for, and control access to resources. For
	// more information, see [Tagging for cost allocation or attribute-based access control (ABAC)].
	//
	// You must have the s3tables:TagResource permission in addition to
	// s3tables:CreateTable permission to create a table with tags.
	//
	// [Tagging for cost allocation or attribute-based access control (ABAC)]: https://docs.aws.amazon.com/AmazonS3/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateTableOutput struct {

	// The Amazon Resource Name (ARN) of the table.
	//
	// This member is required.
	TableARN *string

	// The version token of the table.
	//
	// This member is required.
	VersionToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateTableMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateTable{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateTable{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateTable"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateTableValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateTable(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateTable(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateTable",
	}
}
