// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
	"time"
)

// Creates an S3 Access Grants instance, which serves as a logical grouping for
// access grants. You can create one S3 Access Grants instance per Region per
// account.
//
// Permissions You must have the s3:CreateAccessGrantsInstance permission to use
// this operation.
//
// Additional Permissions To associate an IAM Identity Center instance with your
// S3 Access Grants instance, you must also have the sso:DescribeInstance ,
// sso:CreateApplication , sso:PutApplicationGrant , and
// sso:PutApplicationAuthenticationMethod permissions.
func (c *Client) CreateAccessGrantsInstance(ctx context.Context, params *CreateAccessGrantsInstanceInput, optFns ...func(*Options)) (*CreateAccessGrantsInstanceOutput, error) {
	if params == nil {
		params = &CreateAccessGrantsInstanceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAccessGrantsInstance", params, optFns, c.addOperationCreateAccessGrantsInstanceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAccessGrantsInstanceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAccessGrantsInstanceInput struct {

	// The Amazon Web Services account ID of the S3 Access Grants instance.
	//
	// This member is required.
	AccountId *string

	// If you would like to associate your S3 Access Grants instance with an Amazon
	// Web Services IAM Identity Center instance, use this field to pass the Amazon
	// Resource Name (ARN) of the Amazon Web Services IAM Identity Center instance that
	// you are associating with your S3 Access Grants instance. An IAM Identity Center
	// instance is your corporate identity directory that you added to the IAM Identity
	// Center. You can use the [ListInstances]API operation to retrieve a list of your Identity
	// Center instances and their ARNs.
	//
	// [ListInstances]: https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html
	IdentityCenterArn *string

	// The Amazon Web Services resource tags that you are adding to the S3 Access
	// Grants instance. Each tag is a label consisting of a user-defined key and value.
	// Tags can help you manage, identify, organize, search for, and filter resources.
	Tags []types.Tag

	noSmithyDocumentSerde
}

func (in *CreateAccessGrantsInstanceInput) bindEndpointParams(p *EndpointParameters) {

	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type CreateAccessGrantsInstanceOutput struct {

	// The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
	// instance that you are associating with your S3 Access Grants instance. An IAM
	// Identity Center instance is your corporate identity directory that you added to
	// the IAM Identity Center. You can use the [ListInstances]API operation to retrieve a list of
	// your Identity Center instances and their ARNs.
	//
	// [ListInstances]: https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html
	AccessGrantsInstanceArn *string

	// The ID of the S3 Access Grants instance. The ID is default . You can have one S3
	// Access Grants instance per Region per account.
	AccessGrantsInstanceId *string

	// The date and time when you created the S3 Access Grants instance.
	CreatedAt *time.Time

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name (ARN)
	// of the IAM Identity Center instance application; a subresource of the original
	// Identity Center instance. S3 Access Grants creates this Identity Center
	// application for the specific S3 Access Grants instance.
	IdentityCenterApplicationArn *string

	// If you associated your S3 Access Grants instance with an Amazon Web Services
	// IAM Identity Center instance, this field returns the Amazon Resource Name (ARN)
	// of the IAM Identity Center instance application; a subresource of the original
	// Identity Center instance. S3 Access Grants creates this Identity Center
	// application for the specific S3 Access Grants instance.
	//
	// Deprecated: IdentityCenterArn has been deprecated. Use
	// IdentityCenterInstanceArn or IdentityCenterApplicationArn.
	IdentityCenterArn *string

	// The Amazon Resource Name (ARN) of the Amazon Web Services IAM Identity Center
	// instance that you are associating with your S3 Access Grants instance. An IAM
	// Identity Center instance is your corporate identity directory that you added to
	// the IAM Identity Center. You can use the [ListInstances]API operation to retrieve a list of
	// your Identity Center instances and their ARNs.
	//
	// [ListInstances]: https://docs.aws.amazon.com/singlesignon/latest/APIReference/API_ListInstances.html
	IdentityCenterInstanceArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAccessGrantsInstanceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpCreateAccessGrantsInstance{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpCreateAccessGrantsInstance{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAccessGrantsInstance"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateAccessGrantsInstanceMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateAccessGrantsInstanceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAccessGrantsInstance(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addCreateAccessGrantsInstanceUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateAccessGrantsInstanceMiddleware struct {
}

func (*endpointPrefix_opCreateAccessGrantsInstanceMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateAccessGrantsInstanceMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*CreateAccessGrantsInstanceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateAccessGrantsInstanceMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateAccessGrantsInstanceMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreateAccessGrantsInstance(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAccessGrantsInstance",
	}
}

func copyCreateAccessGrantsInstanceInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*CreateAccessGrantsInstanceInput)
	if !ok {
		return nil, fmt.Errorf("expect *CreateAccessGrantsInstanceInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *CreateAccessGrantsInstanceInput) copy() interface{} {
	v := *in
	return &v
}
func backFillCreateAccessGrantsInstanceAccountID(input interface{}, v string) error {
	in := input.(*CreateAccessGrantsInstanceInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addCreateAccessGrantsInstanceUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyCreateAccessGrantsInstanceInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
