// Code generated by smithy-go-codegen DO NOT EDIT.

package rtbfabric

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/rtbfabric/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAcceptLink struct {
}

func (*validateOpAcceptLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAcceptLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AcceptLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAcceptLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateInboundExternalLink struct {
}

func (*validateOpCreateInboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateInboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateInboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateInboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLink struct {
}

func (*validateOpCreateLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateOutboundExternalLink struct {
}

func (*validateOpCreateOutboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateOutboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateOutboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateOutboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateRequesterGateway struct {
}

func (*validateOpCreateRequesterGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateRequesterGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateRequesterGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateRequesterGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateResponderGateway struct {
}

func (*validateOpCreateResponderGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateResponderGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateResponderGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateResponderGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteInboundExternalLink struct {
}

func (*validateOpDeleteInboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteInboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteInboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteInboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLink struct {
}

func (*validateOpDeleteLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteOutboundExternalLink struct {
}

func (*validateOpDeleteOutboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteOutboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteOutboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteOutboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteRequesterGateway struct {
}

func (*validateOpDeleteRequesterGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteRequesterGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteRequesterGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteRequesterGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteResponderGateway struct {
}

func (*validateOpDeleteResponderGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteResponderGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteResponderGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteResponderGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetInboundExternalLink struct {
}

func (*validateOpGetInboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetInboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetInboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetInboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLink struct {
}

func (*validateOpGetLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetOutboundExternalLink struct {
}

func (*validateOpGetOutboundExternalLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetOutboundExternalLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetOutboundExternalLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetOutboundExternalLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetRequesterGateway struct {
}

func (*validateOpGetRequesterGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetRequesterGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetRequesterGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetRequesterGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetResponderGateway struct {
}

func (*validateOpGetResponderGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetResponderGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetResponderGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetResponderGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListLinks struct {
}

func (*validateOpListLinks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListLinks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListLinksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListLinksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRejectLink struct {
}

func (*validateOpRejectLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRejectLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RejectLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRejectLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLink struct {
}

func (*validateOpUpdateLink) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLink) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLinkInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLinkInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLinkModuleFlow struct {
}

func (*validateOpUpdateLinkModuleFlow) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLinkModuleFlow) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLinkModuleFlowInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLinkModuleFlowInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateRequesterGateway struct {
}

func (*validateOpUpdateRequesterGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateRequesterGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateRequesterGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateRequesterGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateResponderGateway struct {
}

func (*validateOpUpdateResponderGateway) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateResponderGateway) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateResponderGatewayInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateResponderGatewayInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAcceptLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAcceptLink{}, middleware.After)
}

func addOpCreateInboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateInboundExternalLink{}, middleware.After)
}

func addOpCreateLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLink{}, middleware.After)
}

func addOpCreateOutboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateOutboundExternalLink{}, middleware.After)
}

func addOpCreateRequesterGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateRequesterGateway{}, middleware.After)
}

func addOpCreateResponderGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateResponderGateway{}, middleware.After)
}

func addOpDeleteInboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteInboundExternalLink{}, middleware.After)
}

func addOpDeleteLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLink{}, middleware.After)
}

func addOpDeleteOutboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteOutboundExternalLink{}, middleware.After)
}

func addOpDeleteRequesterGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteRequesterGateway{}, middleware.After)
}

func addOpDeleteResponderGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteResponderGateway{}, middleware.After)
}

func addOpGetInboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetInboundExternalLink{}, middleware.After)
}

func addOpGetLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLink{}, middleware.After)
}

func addOpGetOutboundExternalLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetOutboundExternalLink{}, middleware.After)
}

func addOpGetRequesterGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetRequesterGateway{}, middleware.After)
}

func addOpGetResponderGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetResponderGateway{}, middleware.After)
}

func addOpListLinksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListLinks{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRejectLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRejectLink{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateLinkValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLink{}, middleware.After)
}

func addOpUpdateLinkModuleFlowValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLinkModuleFlow{}, middleware.After)
}

func addOpUpdateRequesterGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateRequesterGateway{}, middleware.After)
}

func addOpUpdateResponderGatewayValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateResponderGateway{}, middleware.After)
}

func validateAction(v types.Action) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Action"}
	switch uv := v.(type) {
	case *types.ActionMemberHeaderTag:
		if err := validateHeaderTagAction(&uv.Value); err != nil {
			invalidParams.AddNested("[headerTag]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateAutoScalingGroupsConfiguration(v *types.AutoScalingGroupsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutoScalingGroupsConfiguration"}
	if v.AutoScalingGroupNames == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AutoScalingGroupNames"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEksEndpointsConfiguration(v *types.EksEndpointsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EksEndpointsConfiguration"}
	if v.EndpointsResourceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndpointsResourceName"))
	}
	if v.EndpointsResourceNamespace == nil {
		invalidParams.Add(smithy.NewErrParamRequired("EndpointsResourceNamespace"))
	}
	if v.ClusterApiServerEndpointUri == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterApiServerEndpointUri"))
	}
	if v.ClusterApiServerCaCertificateChain == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterApiServerCaCertificateChain"))
	}
	if v.ClusterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClusterName"))
	}
	if v.RoleArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("RoleArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilter(v *types.Filter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Filter"}
	if v.Criteria == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Criteria"))
	} else if v.Criteria != nil {
		if err := validateFilterCriteria(v.Criteria); err != nil {
			invalidParams.AddNested("Criteria", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterConfiguration(v []types.Filter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterConfiguration"}
	for i := range v {
		if err := validateFilter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterCriteria(v []types.FilterCriterion) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterCriteria"}
	for i := range v {
		if err := validateFilterCriterion(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFilterCriterion(v *types.FilterCriterion) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FilterCriterion"}
	if v.Path == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Path"))
	}
	if v.Values == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Values"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateHeaderTagAction(v *types.HeaderTagAction) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "HeaderTagAction"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLinkApplicationLogConfiguration(v *types.LinkApplicationLogConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LinkApplicationLogConfiguration"}
	if v.Sampling == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Sampling"))
	} else if v.Sampling != nil {
		if err := validateLinkApplicationLogSampling(v.Sampling); err != nil {
			invalidParams.AddNested("Sampling", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLinkApplicationLogSampling(v *types.LinkApplicationLogSampling) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LinkApplicationLogSampling"}
	if v.ErrorLog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ErrorLog"))
	}
	if v.FilterLog == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterLog"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLinkAttributes(v *types.LinkAttributes) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LinkAttributes"}
	if v.ResponderErrorMasking != nil {
		if err := validateResponderErrorMasking(v.ResponderErrorMasking); err != nil {
			invalidParams.AddNested("ResponderErrorMasking", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLinkLogSettings(v *types.LinkLogSettings) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LinkLogSettings"}
	if v.ApplicationLogs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationLogs"))
	} else if v.ApplicationLogs != nil {
		if err := validateLinkApplicationLogConfiguration(v.ApplicationLogs); err != nil {
			invalidParams.AddNested("ApplicationLogs", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateManagedEndpointConfiguration(v types.ManagedEndpointConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ManagedEndpointConfiguration"}
	switch uv := v.(type) {
	case *types.ManagedEndpointConfigurationMemberAutoScalingGroups:
		if err := validateAutoScalingGroupsConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[autoScalingGroups]", err.(smithy.InvalidParamsError))
		}

	case *types.ManagedEndpointConfigurationMemberEksEndpoints:
		if err := validateEksEndpointsConfiguration(&uv.Value); err != nil {
			invalidParams.AddNested("[eksEndpoints]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateModuleConfiguration(v *types.ModuleConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModuleConfiguration"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.ModuleParameters != nil {
		if err := validateModuleParameters(v.ModuleParameters); err != nil {
			invalidParams.AddNested("ModuleParameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateModuleConfigurationList(v []types.ModuleConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModuleConfigurationList"}
	for i := range v {
		if err := validateModuleConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateModuleParameters(v types.ModuleParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ModuleParameters"}
	switch uv := v.(type) {
	case *types.ModuleParametersMemberOpenRtbAttribute:
		if err := validateOpenRtbAttributeModuleParameters(&uv.Value); err != nil {
			invalidParams.AddNested("[openRtbAttribute]", err.(smithy.InvalidParamsError))
		}

	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenRtbAttributeModuleParameters(v *types.OpenRtbAttributeModuleParameters) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenRtbAttributeModuleParameters"}
	if len(v.FilterType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FilterType"))
	}
	if v.FilterConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FilterConfiguration"))
	} else if v.FilterConfiguration != nil {
		if err := validateFilterConfiguration(v.FilterConfiguration); err != nil {
			invalidParams.AddNested("FilterConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Action == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	} else if v.Action != nil {
		if err := validateAction(v.Action); err != nil {
			invalidParams.AddNested("Action", err.(smithy.InvalidParamsError))
		}
	}
	if v.HoldbackPercentage == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HoldbackPercentage"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResponderErrorMasking(v []types.ResponderErrorMaskingForHttpCode) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResponderErrorMasking"}
	for i := range v {
		if err := validateResponderErrorMaskingForHttpCode(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateResponderErrorMaskingForHttpCode(v *types.ResponderErrorMaskingForHttpCode) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ResponderErrorMaskingForHttpCode"}
	if v.HttpCode == nil {
		invalidParams.Add(smithy.NewErrParamRequired("HttpCode"))
	}
	if len(v.Action) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Action"))
	}
	if v.LoggingTypes == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LoggingTypes"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTrustStoreConfiguration(v *types.TrustStoreConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TrustStoreConfiguration"}
	if v.CertificateAuthorityCertificates == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CertificateAuthorityCertificates"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAcceptLinkInput(v *AcceptLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AcceptLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if v.Attributes != nil {
		if err := validateLinkAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.LogSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogSettings"))
	} else if v.LogSettings != nil {
		if err := validateLinkLogSettings(v.LogSettings); err != nil {
			invalidParams.AddNested("LogSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateInboundExternalLinkInput(v *CreateInboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateInboundExternalLinkInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.Attributes != nil {
		if err := validateLinkAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.LogSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogSettings"))
	} else if v.LogSettings != nil {
		if err := validateLinkLogSettings(v.LogSettings); err != nil {
			invalidParams.AddNested("LogSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLinkInput(v *CreateLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.PeerGatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PeerGatewayId"))
	}
	if v.Attributes != nil {
		if err := validateLinkAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.LogSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogSettings"))
	} else if v.LogSettings != nil {
		if err := validateLinkLogSettings(v.LogSettings); err != nil {
			invalidParams.AddNested("LogSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateOutboundExternalLinkInput(v *CreateOutboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOutboundExternalLinkInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.Attributes != nil {
		if err := validateLinkAttributes(v.Attributes); err != nil {
			invalidParams.AddNested("Attributes", err.(smithy.InvalidParamsError))
		}
	}
	if v.PublicEndpoint == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PublicEndpoint"))
	}
	if v.LogSettings == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LogSettings"))
	} else if v.LogSettings != nil {
		if err := validateLinkLogSettings(v.LogSettings); err != nil {
			invalidParams.AddNested("LogSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateRequesterGatewayInput(v *CreateRequesterGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateRequesterGatewayInput"}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.SecurityGroupIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecurityGroupIds"))
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateResponderGatewayInput(v *CreateResponderGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateResponderGatewayInput"}
	if v.VpcId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VpcId"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.SecurityGroupIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SecurityGroupIds"))
	}
	if v.Port == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Port"))
	}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if v.TrustStoreConfiguration != nil {
		if err := validateTrustStoreConfiguration(v.TrustStoreConfiguration); err != nil {
			invalidParams.AddNested("TrustStoreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ManagedEndpointConfiguration != nil {
		if err := validateManagedEndpointConfiguration(v.ManagedEndpointConfiguration); err != nil {
			invalidParams.AddNested("ManagedEndpointConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteInboundExternalLinkInput(v *DeleteInboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteInboundExternalLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLinkInput(v *DeleteLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteOutboundExternalLinkInput(v *DeleteOutboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteOutboundExternalLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteRequesterGatewayInput(v *DeleteRequesterGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteRequesterGatewayInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteResponderGatewayInput(v *DeleteResponderGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteResponderGatewayInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetInboundExternalLinkInput(v *GetInboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetInboundExternalLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLinkInput(v *GetLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetOutboundExternalLinkInput(v *GetOutboundExternalLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetOutboundExternalLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetRequesterGatewayInput(v *GetRequesterGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetRequesterGatewayInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetResponderGatewayInput(v *GetResponderGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetResponderGatewayInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListLinksInput(v *ListLinksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListLinksInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRejectLinkInput(v *RejectLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RejectLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLinkInput(v *UpdateLinkInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLinkInput"}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if v.LogSettings != nil {
		if err := validateLinkLogSettings(v.LogSettings); err != nil {
			invalidParams.AddNested("LogSettings", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLinkModuleFlowInput(v *UpdateLinkModuleFlowInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLinkModuleFlowInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if v.LinkId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LinkId"))
	}
	if v.Modules == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Modules"))
	} else if v.Modules != nil {
		if err := validateModuleConfigurationList(v.Modules); err != nil {
			invalidParams.AddNested("Modules", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateRequesterGatewayInput(v *UpdateRequesterGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateRequesterGatewayInput"}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateResponderGatewayInput(v *UpdateResponderGatewayInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateResponderGatewayInput"}
	if v.Port == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Port"))
	}
	if len(v.Protocol) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Protocol"))
	}
	if v.TrustStoreConfiguration != nil {
		if err := validateTrustStoreConfiguration(v.TrustStoreConfiguration); err != nil {
			invalidParams.AddNested("TrustStoreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ManagedEndpointConfiguration != nil {
		if err := validateManagedEndpointConfiguration(v.ManagedEndpointConfiguration); err != nil {
			invalidParams.AddNested("ManagedEndpointConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientToken == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientToken"))
	}
	if v.GatewayId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("GatewayId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
