// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes a bid action.
//
// The following types satisfy this interface:
//
//	ActionMemberHeaderTag
//	ActionMemberNoBid
type Action interface {
	isAction()
}

// Describes the header tag for a bid action.
type ActionMemberHeaderTag struct {
	Value HeaderTagAction

	noSmithyDocumentSerde
}

func (*ActionMemberHeaderTag) isAction() {}

// Describes a no bid action.
type ActionMemberNoBid struct {
	Value NoBidAction

	noSmithyDocumentSerde
}

func (*ActionMemberNoBid) isAction() {}

// Describes the configuration of an auto scaling group.
type AutoScalingGroupsConfiguration struct {

	// The names of the auto scaling group.
	//
	// This member is required.
	AutoScalingGroupNames []string

	// The role ARN of the auto scaling group.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
type EksEndpointsConfiguration struct {

	// The CA certificate chain of the cluster API server.
	//
	// This member is required.
	ClusterApiServerCaCertificateChain *string

	// The URI of the cluster API server endpoint.
	//
	// This member is required.
	ClusterApiServerEndpointUri *string

	// The name of the cluster.
	//
	// This member is required.
	ClusterName *string

	// The name of the endpoint resource.
	//
	// This member is required.
	EndpointsResourceName *string

	// The namespace of the endpoint resource.
	//
	// This member is required.
	EndpointsResourceNamespace *string

	// The role ARN for the cluster.
	//
	// This member is required.
	RoleArn *string

	noSmithyDocumentSerde
}

// Describes the configuration of a filter.
type Filter struct {

	// Describes the criteria for a filter.
	//
	// This member is required.
	Criteria []FilterCriterion

	noSmithyDocumentSerde
}

// Describes the criteria for a filter.
type FilterCriterion struct {

	// The path to filter.
	//
	// This member is required.
	Path *string

	// The value to filter.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Describes the header tag for a bid action.
type HeaderTagAction struct {

	// The name of the bid action.
	//
	// This member is required.
	Name *string

	// The value of the bid action.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes the configuration of a link application log.
type LinkApplicationLogConfiguration struct {

	// Describes a link application log sample.
	//
	// This member is required.
	Sampling *LinkApplicationLogSampling

	noSmithyDocumentSerde
}

// Describes a link application log sample.
type LinkApplicationLogSampling struct {

	// An error log entry.
	//
	// This member is required.
	ErrorLog *float64

	// A filter log entry.
	//
	// This member is required.
	FilterLog *float64

	noSmithyDocumentSerde
}

// Describes the attributes of a link.
type LinkAttributes struct {

	// The customer-provided unique identifier of the link.
	CustomerProvidedId *string

	// Describes the masking for HTTP error codes.
	ResponderErrorMasking []ResponderErrorMaskingForHttpCode

	noSmithyDocumentSerde
}

// Describes the settings for a link log.
type LinkLogSettings struct {

	// Describes the configuration of a link application log.
	//
	// This member is required.
	ApplicationLogs *LinkApplicationLogConfiguration

	noSmithyDocumentSerde
}

// Describes a link.
type ListLinksResponseStructure struct {

	// The timestamp of when the link was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the gateway.
	//
	// This member is required.
	GatewayId *string

	// The unique identifier of the link.
	//
	// This member is required.
	LinkId *string

	// The unique identifier of the peer gateway.
	//
	// This member is required.
	PeerGatewayId *string

	// The status of the link.
	//
	// This member is required.
	Status LinkStatus

	// The timestamp of when the link was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Describes attributes of a link.
	Attributes *LinkAttributes

	// The direction of the link.
	Direction LinkDirection

	// Describes the configuration of flow modules.
	FlowModules []ModuleConfiguration

	// Describes the configuration of pending flow modules.
	PendingFlowModules []ModuleConfiguration

	// A map of the key-value pairs of the tag or tags to assign to the resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Describes the configuration of a managed endpoint.
//
// The following types satisfy this interface:
//
//	ManagedEndpointConfigurationMemberAutoScalingGroups
//	ManagedEndpointConfigurationMemberEksEndpoints
type ManagedEndpointConfiguration interface {
	isManagedEndpointConfiguration()
}

// Describes the configuration of an auto scaling group.
type ManagedEndpointConfigurationMemberAutoScalingGroups struct {
	Value AutoScalingGroupsConfiguration

	noSmithyDocumentSerde
}

func (*ManagedEndpointConfigurationMemberAutoScalingGroups) isManagedEndpointConfiguration() {}

// Describes the configuration of an Amazon Elastic Kubernetes Service endpoint.
type ManagedEndpointConfigurationMemberEksEndpoints struct {
	Value EksEndpointsConfiguration

	noSmithyDocumentSerde
}

func (*ManagedEndpointConfigurationMemberEksEndpoints) isManagedEndpointConfiguration() {}

// Describes the configuration of a module.
type ModuleConfiguration struct {

	// The name of the module.
	//
	// This member is required.
	Name *string

	// The dependencies of the module.
	DependsOn []string

	// Describes the parameters of a module.
	ModuleParameters ModuleParameters

	// The version of the module.
	Version *string

	noSmithyDocumentSerde
}

// Describes the parameters of a module.
//
// The following types satisfy this interface:
//
//	ModuleParametersMemberNoBid
//	ModuleParametersMemberOpenRtbAttribute
//	ModuleParametersMemberRateLimiter
type ModuleParameters interface {
	isModuleParameters()
}

// Describes the parameters of a no bid module.
type ModuleParametersMemberNoBid struct {
	Value NoBidModuleParameters

	noSmithyDocumentSerde
}

func (*ModuleParametersMemberNoBid) isModuleParameters() {}

// Describes the parameters of an open RTB attribute module.
type ModuleParametersMemberOpenRtbAttribute struct {
	Value OpenRtbAttributeModuleParameters

	noSmithyDocumentSerde
}

func (*ModuleParametersMemberOpenRtbAttribute) isModuleParameters() {}

// Describes the parameters of a rate limit.
type ModuleParametersMemberRateLimiter struct {
	Value RateLimiterModuleParameters

	noSmithyDocumentSerde
}

func (*ModuleParametersMemberRateLimiter) isModuleParameters() {}

// Describes a no bid action.
type NoBidAction struct {

	// The reason code for the no bid action.
	NoBidReasonCode *int32

	noSmithyDocumentSerde
}

// Describes the parameters of a no bid module.
type NoBidModuleParameters struct {

	// The pass through percentage.
	PassThroughPercentage *float32

	// The reason description.
	Reason *string

	// The reason code.
	ReasonCode *int32

	noSmithyDocumentSerde
}

// Describes the parameters of an open RTB attribute module.
type OpenRtbAttributeModuleParameters struct {

	// Describes a bid action.
	//
	// This member is required.
	Action Action

	// Describes the configuration of a filter.
	//
	// This member is required.
	FilterConfiguration []Filter

	// The filter type.
	//
	// This member is required.
	FilterType FilterType

	// The hold back percentage.
	//
	// This member is required.
	HoldbackPercentage *float32

	noSmithyDocumentSerde
}

// Describes the parameters of a rate limit.
type RateLimiterModuleParameters struct {

	// The transactions per second rate limit.
	Tps *float32

	noSmithyDocumentSerde
}

// Describes the masking for HTTP error codes.
type ResponderErrorMaskingForHttpCode struct {

	// The action for the error..
	//
	// This member is required.
	Action ResponderErrorMaskingAction

	// The HTTP error code.
	//
	// This member is required.
	HttpCode *string

	// The error log type.
	//
	// This member is required.
	LoggingTypes []ResponderErrorMaskingLoggingType

	// The percentage of response logging.
	ResponseLoggingPercentage *float32

	noSmithyDocumentSerde
}

// Describes the configuration of a trust store.
type TrustStoreConfiguration struct {

	// The certificate authority certificate.
	//
	// This member is required.
	CertificateAuthorityCertificates []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isAction()                       {}
func (*UnknownUnionMember) isManagedEndpointConfiguration() {}
func (*UnknownUnionMember) isModuleParameters()             {}
