// Code generated by smithy-go-codegen DO NOT EDIT.

package rtbfabric

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/rtbfabric/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Rejects a link request between gateways.
//
// When a requester gateway requests to link with a responder gateway, the
// responder can use this operation to decline the link request.
func (c *Client) RejectLink(ctx context.Context, params *RejectLinkInput, optFns ...func(*Options)) (*RejectLinkOutput, error) {
	if params == nil {
		params = &RejectLinkInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RejectLink", params, optFns, c.addOperationRejectLinkMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RejectLinkOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type RejectLinkInput struct {

	// The unique identifier of the gateway.
	//
	// This member is required.
	GatewayId *string

	// The unique identifier of the link.
	//
	// This member is required.
	LinkId *string

	noSmithyDocumentSerde
}

type RejectLinkOutput struct {

	// The timestamp of when the link was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the gateway.
	//
	// This member is required.
	GatewayId *string

	// The unique identifier of the link.
	//
	// This member is required.
	LinkId *string

	// The unique identifier of the peer gateway.
	//
	// This member is required.
	PeerGatewayId *string

	// The status of the link.
	//
	// This member is required.
	Status types.LinkStatus

	// The timestamp of when the link was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Attributes of the link.
	Attributes *types.LinkAttributes

	// The direction of the link.
	Direction types.LinkDirection

	// The configuration of flow modules.
	FlowModules []types.ModuleConfiguration

	// The configuration of pending flow modules.
	PendingFlowModules []types.ModuleConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRejectLinkMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpRejectLink{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpRejectLink{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RejectLink"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRejectLinkValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRejectLink(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRejectLink(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RejectLink",
	}
}
