// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information about an access source.
type AccessSourcesItem struct {

	// The Amazon Resource Name (ARN) of the access source.
	//
	// This member is required.
	Arn *string

	// The CIDR block that defines the IP address range for the access source.
	//
	// This member is required.
	Cidr *string

	// The date and time when the access source was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view that the access source is associated with.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier of the access source.
	//
	// This member is required.
	Id *string

	// The IP address type of the access source.
	//
	// This member is required.
	IpAddressType IpAddressType

	// The protocol used by the access source.
	//
	// This member is required.
	Protocol DnsProtocol

	// The current status of the access source.
	//
	// This member is required.
	Status CRResourceStatus

	// The date and time when the access source was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The name of the access source.
	Name *string

	noSmithyDocumentSerde
}

// Summary information about a token.
type AccessTokenItem struct {

	// The Amazon Resource Name (ARN) of the token.
	//
	// This member is required.
	Arn *string

	// The date and time when the token was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view associated with the token.
	//
	// This member is required.
	DnsViewId *string

	// The date and time when the token expires.
	//
	// This member is required.
	ExpiresAt *time.Time

	// The ID of the global resolver associated with the token.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the token.
	//
	// This member is required.
	Id *string

	// The current status of the token.
	//
	// This member is required.
	Status TokenStatus

	// The date and time when the token was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The name of the token.
	Name *string

	noSmithyDocumentSerde
}

// Information about a DNS Firewall rule to create in a batch operation.
type BatchCreateFirewallRuleInputItem struct {

	// The action to take when a DNS query matches the firewall rule.
	//
	// This member is required.
	Action FirewallRuleAction

	// A unique string that identifies the request and ensures idempotency.
	//
	// This member is required.
	ClientToken *string

	// The ID of the DNS view to associate the firewall rule with.
	//
	// This member is required.
	DnsViewId *string

	// A name for the firewall rule.
	//
	// This member is required.
	Name *string

	// The DNS record type for the custom response when the action is BLOCK.
	BlockOverrideDnsType BlockOverrideDnsQueryType

	// The custom domain name for the BLOCK response.
	BlockOverrideDomain *string

	// The TTL value for the custom response when the action is BLOCK.
	BlockOverrideTtl *int32

	// The type of block response to return when the action is BLOCK.
	BlockResponse FirewallBlockResponse

	// The confidence threshold for advanced threat detection.
	ConfidenceThreshold ConfidenceThreshold

	// A description of the firewall rule.
	Description *string

	// Whether to enable advanced DNS threat protection for the firewall rule.
	DnsAdvancedProtection DnsAdvancedProtection

	// The ID of the firewall domain list to associate with the rule.
	FirewallDomainListId *string

	// The priority of the firewall rule.
	Priority *int64

	// The DNS query type that the firewall rule should match.
	QType *string

	noSmithyDocumentSerde
}

// Information about the result of creating a DNS Firewall rule in a batch
// operation.
type BatchCreateFirewallRuleOutputItem struct {

	// The HTTP response code for the batch operation result.
	//
	// This member is required.
	Code *int32

	// The firewall rule that was created in the batch operation.
	//
	// This member is required.
	FirewallRule *BatchCreateFirewallRuleResult

	// A message describing the result of the batch operation, including error details
	// if applicable.
	Message *string

	noSmithyDocumentSerde
}

// The result of creating a firewall rule in a batch operation.
type BatchCreateFirewallRuleResult struct {

	// The action configured for the created firewall rule.
	//
	// This member is required.
	Action FirewallRuleAction

	// The unique string that identified the request and ensured idempotency.
	//
	// This member is required.
	ClientToken *string

	// The ID of the DNS view associated with the created firewall rule.
	//
	// This member is required.
	DnsViewId *string

	// The name of the created firewall rule.
	//
	// This member is required.
	Name *string

	// The DNS record type configured for the created firewall rule's custom response.
	BlockOverrideDnsType BlockOverrideDnsQueryType

	// The custom domain name configured for the created firewall rule's BLOCK
	// response.
	BlockOverrideDomain *string

	// The TTL value configured for the created firewall rule's custom response.
	BlockOverrideTtl *int32

	// The type of block response configured for the created firewall rule.
	BlockResponse FirewallBlockResponse

	// The confidence threshold configured for the created firewall rule's advanced
	// threat detection.
	ConfidenceThreshold ConfidenceThreshold

	// The date and time when the firewall rule was created.
	CreatedAt *time.Time

	// The description of the created firewall rule.
	Description *string

	// Whether advanced DNS threat protection is enabled for the created firewall rule.
	DnsAdvancedProtection DnsAdvancedProtection

	// The ID of the firewall domain list associated with the created firewall rule.
	FirewallDomainListId *string

	// The unique identifier of the created firewall rule.
	Id *string

	// The name of the managed domain list associated with the created firewall rule.
	ManagedDomainListName *string

	// The priority of the created firewall rule.
	Priority *int64

	// The DNS query type that the created firewall rule matches.
	QueryType *string

	// The current status of the created firewall rule.
	Status CRResourceStatus

	// The date and time when the firewall rule was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Information about a DNS Firewall rule to delete in a batch operation.
type BatchDeleteFirewallRuleInputItem struct {

	// The ID of the DNS Firewall rule to delete.
	//
	// This member is required.
	FirewallRuleId *string

	noSmithyDocumentSerde
}

// The result of deleting a firewall rule in a batch operation.
type BatchDeleteFirewallRuleOutputItem struct {

	// The response code for the delete operation.
	//
	// This member is required.
	Code *int32

	// The firewall rule that was deleted in the batch operation.
	//
	// This member is required.
	FirewallRule *BatchDeleteFirewallRuleResult

	// The response message for the delete operation.
	Message *string

	noSmithyDocumentSerde
}

// Information about a firewall rule that was deleted in a batch operation.
type BatchDeleteFirewallRuleResult struct {

	// The unique identifier of the deleted firewall rule.
	//
	// This member is required.
	Id *string

	// The unique string that identified the request and ensured idempotency.
	ClientToken *string

	// The name of the deleted firewall rule.
	Name *string

	// The final status of the deleted firewall rule.
	Status CRResourceStatus

	noSmithyDocumentSerde
}

// Information for updating a firewall rule in a batch operation.
type BatchUpdateFirewallRuleInputItem struct {

	// The unique identifier of the firewall rule to update.
	//
	// This member is required.
	FirewallRuleId *string

	// The action to take when a DNS query matches the firewall rule.
	Action FirewallRuleAction

	// The DNS record type for the custom response when the action is BLOCK.
	BlockOverrideDnsType BlockOverrideDnsQueryType

	// The custom domain name for the BLOCK response.
	BlockOverrideDomain *string

	// The TTL value for the custom response when the action is BLOCK.
	BlockOverrideTtl *int32

	// The type of block response to return when the action is BLOCK.
	BlockResponse FirewallBlockResponse

	// The confidence threshold for advanced threat detection.
	ConfidenceThreshold ConfidenceThreshold

	// A description of the firewall rule.
	Description *string

	// Whether to enable advanced DNS threat protection for the firewall rule.
	DnsAdvancedProtection DnsAdvancedProtection

	// A name for the firewall rule.
	Name *string

	// The priority of the firewall rule.
	Priority *int64

	noSmithyDocumentSerde
}

// The result of updating a firewall rule in a batch operation.
type BatchUpdateFirewallRuleOutputItem struct {

	// The response code for the update operation.
	//
	// This member is required.
	Code *int32

	// The firewall rule that was updated in the batch operation.
	//
	// This member is required.
	FirewallRule *BatchUpdateFirewallRuleResult

	// The response message for the update operation.
	Message *string

	noSmithyDocumentSerde
}

// Information about a firewall rule that was updated in a batch operation.
type BatchUpdateFirewallRuleResult struct {

	// The unique identifier of the updated firewall rule.
	//
	// This member is required.
	Id *string

	// The action configured for the updated firewall rule.
	Action FirewallRuleAction

	// The DNS record type configured for the updated firewall rule's custom response.
	BlockOverrideDnsType BlockOverrideDnsQueryType

	// The custom domain name configured for the updated firewall rule's BLOCK
	// response.
	BlockOverrideDomain *string

	// The TTL value configured for the updated firewall rule's custom response.
	BlockOverrideTtl *int32

	// The type of block response configured for the updated firewall rule.
	BlockResponse FirewallBlockResponse

	// The unique string that identified the request and ensured idempotency.
	ClientToken *string

	// The confidence threshold configured for the updated firewall rule's advanced
	// threat detection.
	ConfidenceThreshold ConfidenceThreshold

	// The date and time when the firewall rule was originally created.
	CreatedAt *time.Time

	// The description of the updated firewall rule.
	Description *string

	// Whether advanced DNS threat protection is enabled for the updated firewall rule.
	DnsAdvancedProtection DnsAdvancedProtection

	// The ID of the DNS view associated with the updated firewall rule.
	DnsViewId *string

	// The ID of the firewall domain list associated with the updated firewall rule.
	FirewallDomainListId *string

	// The name of the updated firewall rule.
	Name *string

	// The priority of the updated firewall rule.
	Priority *int64

	// The DNS query type that the updated firewall rule matches.
	QueryType *string

	// The current status of the updated firewall rule.
	Status CRResourceStatus

	// The date and time when the firewall rule was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary information about a DNS view.
type DNSViewSummary struct {

	// The Amazon Resource Name (ARN) of the DNS view.
	//
	// This member is required.
	Arn *string

	// The unique string that identifies the request and ensures idempotency.
	//
	// This member is required.
	ClientToken *string

	// The date and time when the DNS view was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Whether DNSSEC validation is enabled for the DNS view.
	//
	// This member is required.
	DnssecValidation DnsSecValidationType

	// Whether EDNS Client Subnet injection is enabled for the DNS view.
	//
	// This member is required.
	EdnsClientSubnet EdnsClientSubnetType

	// Whether firewall rules fail open when they cannot be evaluated.
	//
	// This member is required.
	FirewallRulesFailOpen FirewallRulesFailOpenType

	// The ID of the global resolver that the DNS view is associated with.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the DNS view.
	//
	// This member is required.
	Id *string

	// The name of the DNS view.
	//
	// This member is required.
	Name *string

	// The current status of the DNS view.
	//
	// This member is required.
	Status ProfileResourceStatus

	// The date and time when the DNS view was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A description of the DNS view.
	Description *string

	noSmithyDocumentSerde
}

// Summary information about a firewall domain list.
type FirewallDomainListsItem struct {

	// The Amazon Resource Name (ARN) of the firewall domain list.
	//
	// This member is required.
	Arn *string

	// The date and time when the firewall domain list was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the global resolver that the firewall domain list is associated with.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the firewall domain list.
	//
	// This member is required.
	Id *string

	// The name of the firewall domain list.
	//
	// This member is required.
	Name *string

	// The current status of the firewall domain list.
	//
	// This member is required.
	Status CRResourceStatus

	// The date and time when the firewall domain list was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A description of the firewall domain list.
	Description *string

	noSmithyDocumentSerde
}

// Summary information about a firewall rule.
type FirewallRulesItem struct {

	// The action configured for the firewall rule.
	//
	// This member is required.
	Action FirewallRuleAction

	// The date and time when the firewall rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the DNS view associated with the firewall rule.
	//
	// This member is required.
	DnsViewId *string

	// The unique identifier of the firewall rule.
	//
	// This member is required.
	Id *string

	// The name of the firewall rule.
	//
	// This member is required.
	Name *string

	// The priority of the firewall rule.
	//
	// This member is required.
	Priority *int64

	// The current status of the firewall rule.
	//
	// This member is required.
	Status CRResourceStatus

	// The date and time when the firewall rule was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The DNS record type configured for the firewall rule's custom response.
	BlockOverrideDnsType BlockOverrideDnsQueryType

	// The custom domain name configured for the firewall rule's BLOCK response.
	BlockOverrideDomain *string

	// The TTL value configured for the firewall rule's custom response.
	BlockOverrideTtl *int32

	// The type of block response configured for the firewall rule.
	BlockResponse FirewallBlockResponse

	// The confidence threshold configured for the firewall rule's advanced threat
	// detection.
	ConfidenceThreshold ConfidenceThreshold

	// The description of the firewall rule.
	Description *string

	// Whether advanced DNS threat protection is enabled for the firewall rule.
	DnsAdvancedProtection DnsAdvancedProtection

	// The ID of the firewall domain list associated with the firewall rule.
	FirewallDomainListId *string

	// The DNS query type that the firewall rule matches.
	QueryType *string

	noSmithyDocumentSerde
}

// Summary information about a global resolver.
type GlobalResolversItem struct {

	// The Amazon Resource Name (ARN) of the global resolver.
	//
	// This member is required.
	Arn *string

	// The unique string that identifies the request and ensures idempotency.
	//
	// This member is required.
	ClientToken *string

	// The date and time when the global resolver was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The DNS name of the global resolver.
	//
	// This member is required.
	DnsName *string

	// The unique identifier of the global resolver.
	//
	// This member is required.
	Id *string

	// The IPv4 addresses assigned to the global resolver.
	//
	// This member is required.
	Ipv4Addresses []string

	// The name of the global resolver.
	//
	// This member is required.
	Name *string

	// The AWS Regions where the global resolver is deployed.
	//
	// This member is required.
	Regions []string

	// The current status of the global resolver.
	//
	// This member is required.
	Status CRResourceStatus

	// The date and time when the global resolver was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A description of the global resolver.
	Description *string

	// The AWS Region where observability data is collected for the global resolver.
	ObservabilityRegion *string

	noSmithyDocumentSerde
}

// Summary information about a hosted zone association.
type HostedZoneAssociationSummary struct {

	// The date and time when the hosted zone association was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the hosted zone.
	//
	// This member is required.
	HostedZoneId *string

	// The name of the hosted zone.
	//
	// This member is required.
	HostedZoneName *string

	// The unique identifier of the hosted zone association.
	//
	// This member is required.
	Id *string

	// The name of the hosted zone association.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the resource associated with the hosted zone.
	//
	// This member is required.
	ResourceArn *string

	// The current status of the hosted zone association.
	//
	// This member is required.
	Status HostedZoneAssociationStatus

	// The date and time when the hosted zone association was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Summary information about a managed firewall domain list.
type ManagedFirewallDomainListsItem struct {

	// The unique identifier of the managed firewall domain list.
	//
	// This member is required.
	Id *string

	// The type of the managed firewall domain list.
	//
	// This member is required.
	ManagedListType *string

	// The name of the managed firewall domain list.
	//
	// This member is required.
	Name *string

	// A description of the managed firewall domain list.
	Description *string

	noSmithyDocumentSerde
}

// Information about a field that failed validation.
type ValidationExceptionField struct {

	// The validation error message for the field.
	//
	// This member is required.
	Message *string

	// The name of the field that failed validation.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
