// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates the configuration of a hosted zone association.
func (c *Client) UpdateHostedZoneAssociation(ctx context.Context, params *UpdateHostedZoneAssociationInput, optFns ...func(*Options)) (*UpdateHostedZoneAssociationOutput, error) {
	if params == nil {
		params = &UpdateHostedZoneAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateHostedZoneAssociation", params, optFns, c.addOperationUpdateHostedZoneAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateHostedZoneAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateHostedZoneAssociationInput struct {

	// The ID of the private hosted zone association.
	//
	// This member is required.
	HostedZoneAssociationId *string

	// The name you want to update the hosted zone association to.
	Name *string

	noSmithyDocumentSerde
}

type UpdateHostedZoneAssociationOutput struct {

	// The time and date the private hosted zone association was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ID of the private hosted zone.
	//
	// This member is required.
	HostedZoneId *string

	// The name of the domain associated with the private hosted zone.
	//
	// This member is required.
	HostedZoneName *string

	// The ID of the private hosted zone association.
	//
	// This member is required.
	Id *string

	// The name of the private hosted zone association.
	//
	// This member is required.
	Name *string

	// The Amazon Resource Name (ARN) of the private hosted zone association.
	//
	// This member is required.
	ResourceArn *string

	// The operational status of the private hosted zone association.
	//
	// This member is required.
	Status types.HostedZoneAssociationStatus

	// The time and date the private hosted zone association was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateHostedZoneAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateHostedZoneAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateHostedZoneAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateHostedZoneAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateHostedZoneAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateHostedZoneAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateHostedZoneAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateHostedZoneAssociation",
	}
}
