// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all DNS views for a Route 53 Global Resolver with pagination support.
func (c *Client) ListDNSViews(ctx context.Context, params *ListDNSViewsInput, optFns ...func(*Options)) (*ListDNSViewsOutput, error) {
	if params == nil {
		params = &ListDNSViewsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDNSViews", params, optFns, c.addOperationListDNSViewsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDNSViewsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDNSViewsInput struct {

	// The Global Resolver ID.
	//
	// This member is required.
	GlobalResolverId *string

	// The maximum number of results to retrieve in a single call.
	MaxResults *int32

	// A pagination token used for large sets of results that can't be returned in a
	// single response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDNSViewsOutput struct {

	// An array of information about the DNS views, such as whether DNSSEC is enabled,
	// creation time, etc.
	//
	// This member is required.
	DnsViews []types.DNSViewSummary

	// A pagination token used for large sets of results that can't be returned in a
	// single response. Provide this token in the next call to get the results not
	// returned in this call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDNSViewsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDNSViews{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDNSViews{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDNSViews"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDNSViewsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDNSViews(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDNSViewsPaginatorOptions is the paginator options for ListDNSViews
type ListDNSViewsPaginatorOptions struct {
	// The maximum number of results to retrieve in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDNSViewsPaginator is a paginator for ListDNSViews
type ListDNSViewsPaginator struct {
	options   ListDNSViewsPaginatorOptions
	client    ListDNSViewsAPIClient
	params    *ListDNSViewsInput
	nextToken *string
	firstPage bool
}

// NewListDNSViewsPaginator returns a new ListDNSViewsPaginator
func NewListDNSViewsPaginator(client ListDNSViewsAPIClient, params *ListDNSViewsInput, optFns ...func(*ListDNSViewsPaginatorOptions)) *ListDNSViewsPaginator {
	if params == nil {
		params = &ListDNSViewsInput{}
	}

	options := ListDNSViewsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDNSViewsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDNSViewsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDNSViews page.
func (p *ListDNSViewsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDNSViewsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDNSViews(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDNSViewsAPIClient is a client that implements the ListDNSViews operation.
type ListDNSViewsAPIClient interface {
	ListDNSViews(context.Context, *ListDNSViewsInput, ...func(*Options)) (*ListDNSViewsOutput, error)
}

var _ ListDNSViewsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDNSViews(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDNSViews",
	}
}
