// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all access tokens for a DNS view with pagination support.
func (c *Client) ListAccessTokens(ctx context.Context, params *ListAccessTokensInput, optFns ...func(*Options)) (*ListAccessTokensOutput, error) {
	if params == nil {
		params = &ListAccessTokensInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccessTokens", params, optFns, c.addOperationListAccessTokensMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccessTokensOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccessTokensInput struct {

	// The ID of the DNS view to list the tokens for.
	//
	// This member is required.
	DnsViewId *string

	// Filtering parameters.
	Filters map[string][]string

	// The maximum number of results to retrieve in a single call.
	MaxResults *int32

	// A pagination token used for large sets of results that can't be returned in a
	// single response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccessTokensOutput struct {

	// List of the tokens.
	AccessTokens []types.AccessTokenItem

	// A pagination token used for large sets of results that can't be returned in a
	// single response. Provide this token in the next call to get the results not
	// returned in this call.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccessTokensMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAccessTokens{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAccessTokens{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccessTokens"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAccessTokensValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccessTokens(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAccessTokensPaginatorOptions is the paginator options for ListAccessTokens
type ListAccessTokensPaginatorOptions struct {
	// The maximum number of results to retrieve in a single call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccessTokensPaginator is a paginator for ListAccessTokens
type ListAccessTokensPaginator struct {
	options   ListAccessTokensPaginatorOptions
	client    ListAccessTokensAPIClient
	params    *ListAccessTokensInput
	nextToken *string
	firstPage bool
}

// NewListAccessTokensPaginator returns a new ListAccessTokensPaginator
func NewListAccessTokensPaginator(client ListAccessTokensAPIClient, params *ListAccessTokensInput, optFns ...func(*ListAccessTokensPaginatorOptions)) *ListAccessTokensPaginator {
	if params == nil {
		params = &ListAccessTokensInput{}
	}

	options := ListAccessTokensPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccessTokensPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccessTokensPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccessTokens page.
func (p *ListAccessTokensPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccessTokensOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccessTokens(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccessTokensAPIClient is a client that implements the ListAccessTokens
// operation.
type ListAccessTokensAPIClient interface {
	ListAccessTokens(context.Context, *ListAccessTokensInput, ...func(*Options)) (*ListAccessTokensOutput, error)
}

var _ ListAccessTokensAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccessTokens(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccessTokens",
	}
}
