// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a Route 53 Global Resolver instance.
func (c *Client) GetGlobalResolver(ctx context.Context, params *GetGlobalResolverInput, optFns ...func(*Options)) (*GetGlobalResolverOutput, error) {
	if params == nil {
		params = &GetGlobalResolverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetGlobalResolver", params, optFns, c.addOperationGetGlobalResolverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetGlobalResolverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetGlobalResolverInput struct {

	// The ID of the Route 53 Global Resolver to retrieve information about.
	//
	// This member is required.
	GlobalResolverId *string

	noSmithyDocumentSerde
}

type GetGlobalResolverOutput struct {

	// The Amazon Resource Name (ARN) of the Global Resolver.
	//
	// This member is required.
	Arn *string

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	//
	// This member is required.
	ClientToken *string

	// The date and time the Global Resolver was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The hostname used by the customers' DNS clients for certification validation.
	//
	// This member is required.
	DnsName *string

	// The ID of the Global Resolver.
	//
	// This member is required.
	Id *string

	// List of anycast IPv4 addresses associated with the Global Resolver instance.
	//
	// This member is required.
	Ipv4Addresses []string

	// The name of the Global Resolver.
	//
	// This member is required.
	Name *string

	// The AWS Regions in which the Global Resolver operate.
	//
	// This member is required.
	Regions []string

	// The operational status of the Global Resolver.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time the Global Resolver was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the Global Resolver.
	Description *string

	// The AWS Regions in which the users' Global Resolver query resolution logs will
	// be propagated.
	ObservabilityRegion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetGlobalResolverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetGlobalResolver"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetGlobalResolverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetGlobalResolver(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetGlobalResolver(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetGlobalResolver",
	}
}
