// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a DNS firewall rule.
func (c *Client) GetFirewallRule(ctx context.Context, params *GetFirewallRuleInput, optFns ...func(*Options)) (*GetFirewallRuleOutput, error) {
	if params == nil {
		params = &GetFirewallRuleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFirewallRule", params, optFns, c.addOperationGetFirewallRuleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFirewallRuleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFirewallRuleInput struct {

	// ID of the DNS Firewall rule.
	//
	// This member is required.
	FirewallRuleId *string

	noSmithyDocumentSerde
}

type GetFirewallRuleOutput struct {

	// The action that DNS Firewall should take on a DNS query when it matches one of
	// the domains in the rule's domain list, or a threat in a DNS Firewall Advanced
	// rule.
	//
	// This member is required.
	Action types.FirewallRuleAction

	// The time and date the DNS Firewall rule was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The DNS view ID the DNS Firewall is associated with.
	//
	// This member is required.
	DnsViewId *string

	// ID of the DNS Firewall rule.
	//
	// This member is required.
	Id *string

	// The name of the DNS Firewall rule.
	//
	// This member is required.
	Name *string

	// The setting that determines the processing order of the rule in the rule group.
	// DNS Firewall processes the rules in a rule group by order of priority, starting
	// from the lowest setting.
	//
	// This member is required.
	Priority *int64

	// The operational status of the DNS Firewall rule.
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time the DNS Firewall rule was updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The DNS record's type. This determines the format of the record value that you
	// provided in BlockOverrideDomain . Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideDnsType types.BlockOverrideDnsQueryType

	// The custom DNS record to send back in response to the query. Used for the rule
	// action BLOCK with a BlockResponse setting of OVERRIDE .
	BlockOverrideDomain *string

	// The recommended amount of time, in seconds, for the DNS resolver or web browser
	// to cache the provided override record. Used for the rule action BLOCK with a
	// BlockResponse setting of OVERRIDE .
	BlockOverrideTtl *int32

	// The way that you want DNS Firewall to block the request. Used for the rule
	// action setting BLOCK .
	BlockResponse types.FirewallBlockResponse

	// The confidence threshold for DNS Firewall Advanced. You must provide this value
	// when you create a DNS Firewall Advanced rule.
	ConfidenceThreshold types.ConfidenceThreshold

	// The description of the DNS Firewall rule.
	Description *string

	// The type of the DNS Firewall Advanced rule. Valid values are DGA and
	// DNS_TUNNELING.
	DnsAdvancedProtection types.DnsAdvancedProtection

	// The ID of a DNS Firewall domain list.
	FirewallDomainListId *string

	// The DNS query type you want the rule to evaluate.
	QueryType *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFirewallRuleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFirewallRule{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFirewallRule"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFirewallRuleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFirewallRule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFirewallRule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFirewallRule",
	}
}
