// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a DNS view.
func (c *Client) GetDNSView(ctx context.Context, params *GetDNSViewInput, optFns ...func(*Options)) (*GetDNSViewOutput, error) {
	if params == nil {
		params = &GetDNSViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDNSView", params, optFns, c.addOperationGetDNSViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDNSViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDNSViewInput struct {

	// The ID of the DNS view to retrieve information about.
	//
	// This member is required.
	DnsViewId *string

	noSmithyDocumentSerde
}

type GetDNSViewOutput struct {

	// Amazon Resource Name (ARN) of the DNS view.
	//
	// This member is required.
	Arn *string

	// The time and date the DNS view was creates on.
	//
	// This member is required.
	CreatedAt *time.Time

	// Specifies whether DNSSEC is enabled or disabled for the DNS view.
	//
	// This member is required.
	DnssecValidation types.DnsSecValidationType

	// Specifies whether edns0 client subnet is enabled.
	//
	// This member is required.
	EdnsClientSubnet types.EdnsClientSubnetType

	// Specifies the DNS Firewall failure mode configuration. When enabled, the DNS
	// Firewall allows DNS queries to proceed if it's unable to properly evaluate them.
	// When disabled, the DNS Firewall blocks DNS queries it's unable to evaluate.
	//
	// This member is required.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// ID of the Global Resolver the DNS view is associated to.
	//
	// This member is required.
	GlobalResolverId *string

	// ID of the DNS view.
	//
	// This member is required.
	Id *string

	// Name of the DNS view.
	//
	// This member is required.
	Name *string

	// Operational status of the DNS view.
	//
	// This member is required.
	Status types.ProfileResourceStatus

	// The time and date the DNS view was updated on.
	//
	// This member is required.
	UpdatedAt *time.Time

	// A unique, case-sensitive identifier to ensure idempotency. This means that
	// making the same request multiple times with the same clientToken has the same
	// result every time.
	ClientToken *string

	// Description of the DNS view.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDNSViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDNSView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetDNSViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDNSView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDNSView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDNSView",
	}
}
