// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Deletes a DNS view. This operation cannot be undone.
func (c *Client) DeleteDNSView(ctx context.Context, params *DeleteDNSViewInput, optFns ...func(*Options)) (*DeleteDNSViewOutput, error) {
	if params == nil {
		params = &DeleteDNSViewInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteDNSView", params, optFns, c.addOperationDeleteDNSViewMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteDNSViewOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteDNSViewInput struct {

	// The unique identifier of the DNS view to delete.
	//
	// This member is required.
	DnsViewId *string

	noSmithyDocumentSerde
}

type DeleteDNSViewOutput struct {

	// The Amazon Resource Name (ARN) of the deleted DNS view.
	//
	// This member is required.
	Arn *string

	// The date and time when the DNS view was originally created.
	//
	// This member is required.
	CreatedAt *time.Time

	// Whether DNSSEC validation was enabled for the deleted DNS view.
	//
	// This member is required.
	DnssecValidation types.DnsSecValidationType

	// Whether EDNS Client Subnet injection was enabled for the deleted DNS view.
	//
	// This member is required.
	EdnsClientSubnet types.EdnsClientSubnetType

	// The firewall rules fail-open behavior that was configured for the deleted DNS
	// view.
	//
	// This member is required.
	FirewallRulesFailOpen types.FirewallRulesFailOpenType

	// The ID of the Route 53 Global Resolver that the deleted DNS view was associated
	// with.
	//
	// This member is required.
	GlobalResolverId *string

	// The unique identifier of the deleted DNS view.
	//
	// This member is required.
	Id *string

	// The name of the deleted DNS view.
	//
	// This member is required.
	Name *string

	// The final status of the deleted DNS view.
	//
	// This member is required.
	Status types.ProfileResourceStatus

	// The date and time when the DNS view was last updated before deletion.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The unique string that identifies the request and ensures idempotency.
	ClientToken *string

	// The description of the deleted DNS view.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteDNSViewMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteDNSView{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DeleteDNSView"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDeleteDNSViewValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteDNSView(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteDNSView(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DeleteDNSView",
	}
}
