// Code generated by smithy-go-codegen DO NOT EDIT.

package route53globalresolver

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/route53globalresolver/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new Route 53 Global Resolver instance. A Route 53 Global Resolver is
// a global, internet-accessible DNS resolver that provides secure DNS resolution
// for both public and private domains through global anycast IP addresses.
func (c *Client) CreateGlobalResolver(ctx context.Context, params *CreateGlobalResolverInput, optFns ...func(*Options)) (*CreateGlobalResolverOutput, error) {
	if params == nil {
		params = &CreateGlobalResolverInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGlobalResolver", params, optFns, c.addOperationCreateGlobalResolverMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGlobalResolverOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGlobalResolverInput struct {

	// A descriptive name for the Route 53 Global Resolver instance. Maximum length of
	// 64 characters.
	//
	// This member is required.
	Name *string

	// List of AWS regions where the Route 53 Global Resolver will operate. The
	// resolver will be distributed across these regions to provide global availability
	// and low-latency DNS resolution.
	//
	// This member is required.
	Regions []string

	// A unique string that identifies the request and ensures idempotency. If you
	// make multiple requests with the same client token, only one Route 53 Global
	// Resolver is created.
	ClientToken *string

	// An optional description for the Route 53 Global Resolver instance. Maximum
	// length of 1024 characters.
	Description *string

	// The AWS region where query resolution logs and metrics will be aggregated and
	// delivered. If not specified, logging is not enabled.
	ObservabilityRegion *string

	// Tags to associate with the Route 53 Global Resolver. Tags are key-value pairs
	// that help you organize and identify your resources.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateGlobalResolverOutput struct {

	// The Amazon Resource Name (ARN) of the Route 53 Global Resolver.
	//
	// This member is required.
	Arn *string

	// The unique string that identifies the request and ensures idempotency.
	//
	// This member is required.
	ClientToken *string

	// The date and time when the Route 53 Global Resolver was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The hostname that DNS clients should use for TLS certificate validation when
	// connecting to the Route 53 Global Resolver. This value resolves to the global
	// anycast IP addresses for the resolver.
	//
	// This member is required.
	DnsName *string

	// The unique identifier for the Route 53 Global Resolver.
	//
	// This member is required.
	Id *string

	// The global anycast IPv4 addresses associated with the Route 53 Global Resolver.
	// DNS clients can send queries to these addresses from anywhere on the internet.
	//
	// This member is required.
	Ipv4Addresses []string

	// The name of the Route 53 Global Resolver.
	//
	// This member is required.
	Name *string

	// The AWS Regions where the Route 53 Global Resolver is deployed and operational.
	//
	// This member is required.
	Regions []string

	// The current status of the Route 53 Global Resolver. Possible values are
	// CREATING (being provisioned), UPDATING (being modified), OPERATIONAL (ready to
	// serve queries), or DELETING (being removed).
	//
	// This member is required.
	Status types.CRResourceStatus

	// The date and time when the Route 53 Global Resolver was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The description of the Route 53 Global Resolver.
	Description *string

	// The AWS Region where observability data for the Route 53 Global Resolver is
	// stored.
	ObservabilityRegion *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGlobalResolverMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGlobalResolver{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGlobalResolver"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateGlobalResolverMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGlobalResolverValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGlobalResolver(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateGlobalResolver struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateGlobalResolver) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateGlobalResolver) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateGlobalResolverInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateGlobalResolverInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateGlobalResolverMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateGlobalResolver{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateGlobalResolver(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGlobalResolver",
	}
}
