// Code generated by smithy-go-codegen DO NOT EDIT.

package resourcegroupstaggingapi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourcegroupstaggingapi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the required tags for supported resource types in an Amazon Web Services
// account.
func (c *Client) ListRequiredTags(ctx context.Context, params *ListRequiredTagsInput, optFns ...func(*Options)) (*ListRequiredTagsOutput, error) {
	if params == nil {
		params = &ListRequiredTagsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRequiredTags", params, optFns, c.addOperationListRequiredTagsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRequiredTagsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRequiredTagsInput struct {

	// The maximum number of required tags.
	MaxResults *int32

	// A token for requesting another page of required tags if the NextToken response
	// element indicates that more required tags are available. Use the value of the
	// returned NextToken element in your request until the token comes back as null.
	// Pass null if this is the first call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListRequiredTagsOutput struct {

	// A token for requesting another page of required tags if the NextToken response
	// element indicates that more required tags are available. Use the value of the
	// returned NextToken element in your request until the token comes back as null.
	// Pass null if this is the first call.
	NextToken *string

	// The required tags.
	RequiredTags []types.RequiredTag

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRequiredTagsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListRequiredTags{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListRequiredTags{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRequiredTags"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRequiredTags(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListRequiredTagsPaginatorOptions is the paginator options for ListRequiredTags
type ListRequiredTagsPaginatorOptions struct {
	// The maximum number of required tags.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListRequiredTagsPaginator is a paginator for ListRequiredTags
type ListRequiredTagsPaginator struct {
	options   ListRequiredTagsPaginatorOptions
	client    ListRequiredTagsAPIClient
	params    *ListRequiredTagsInput
	nextToken *string
	firstPage bool
}

// NewListRequiredTagsPaginator returns a new ListRequiredTagsPaginator
func NewListRequiredTagsPaginator(client ListRequiredTagsAPIClient, params *ListRequiredTagsInput, optFns ...func(*ListRequiredTagsPaginatorOptions)) *ListRequiredTagsPaginator {
	if params == nil {
		params = &ListRequiredTagsInput{}
	}

	options := ListRequiredTagsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListRequiredTagsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListRequiredTagsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListRequiredTags page.
func (p *ListRequiredTagsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListRequiredTagsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListRequiredTags(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListRequiredTagsAPIClient is a client that implements the ListRequiredTags
// operation.
type ListRequiredTagsAPIClient interface {
	ListRequiredTags(context.Context, *ListRequiredTagsInput, ...func(*Options)) (*ListRequiredTagsOutput, error)
}

var _ ListRequiredTagsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListRequiredTags(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRequiredTags",
	}
}
