// Code generated by smithy-go-codegen DO NOT EDIT.

package resourceexplorer2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists all Resource Explorer service views available in the current Amazon Web
// Services account. This operation returns the ARNs of available service views.
func (c *Client) ListServiceViews(ctx context.Context, params *ListServiceViewsInput, optFns ...func(*Options)) (*ListServiceViewsOutput, error) {
	if params == nil {
		params = &ListServiceViewsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceViews", params, optFns, c.addOperationListServiceViewsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceViewsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceViewsInput struct {

	// The maximum number of service view results to return in a single response.
	// Valid values are between 1 and 50 .
	MaxResults *int32

	// The pagination token from a previous ListServiceViews response. Use this token
	// to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListServiceViewsOutput struct {

	// The pagination token to use in a subsequent ListServiceViews request to
	// retrieve the next set of results.
	NextToken *string

	// A list of Amazon Resource Names (ARNs) for the service views available in the
	// current Amazon Web Services account.
	ServiceViews []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceViewsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceViews{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceViews{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceViews"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceViews(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListServiceViewsPaginatorOptions is the paginator options for ListServiceViews
type ListServiceViewsPaginatorOptions struct {
	// The maximum number of service view results to return in a single response.
	// Valid values are between 1 and 50 .
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceViewsPaginator is a paginator for ListServiceViews
type ListServiceViewsPaginator struct {
	options   ListServiceViewsPaginatorOptions
	client    ListServiceViewsAPIClient
	params    *ListServiceViewsInput
	nextToken *string
	firstPage bool
}

// NewListServiceViewsPaginator returns a new ListServiceViewsPaginator
func NewListServiceViewsPaginator(client ListServiceViewsAPIClient, params *ListServiceViewsInput, optFns ...func(*ListServiceViewsPaginatorOptions)) *ListServiceViewsPaginator {
	if params == nil {
		params = &ListServiceViewsInput{}
	}

	options := ListServiceViewsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceViewsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceViewsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceViews page.
func (p *ListServiceViewsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceViewsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceViews(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceViewsAPIClient is a client that implements the ListServiceViews
// operation.
type ListServiceViewsAPIClient interface {
	ListServiceViews(context.Context, *ListServiceViewsInput, ...func(*Options)) (*ListServiceViewsOutput, error)
}

var _ ListServiceViewsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceViews(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceViews",
	}
}
