// Code generated by smithy-go-codegen DO NOT EDIT.

package resourceexplorer2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a Resource Explorer setup configuration across multiple Amazon Web
// Services Regions. This operation sets up indexes and views in the specified
// Regions. This operation can also be used to set an aggregator Region for
// cross-Region resource search.
func (c *Client) CreateResourceExplorerSetup(ctx context.Context, params *CreateResourceExplorerSetupInput, optFns ...func(*Options)) (*CreateResourceExplorerSetupOutput, error) {
	if params == nil {
		params = &CreateResourceExplorerSetupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateResourceExplorerSetup", params, optFns, c.addOperationCreateResourceExplorerSetupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateResourceExplorerSetupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateResourceExplorerSetupInput struct {

	// A list of Amazon Web Services Regions where Resource Explorer should be
	// configured. Each Region in the list will have a user-owned index created.
	//
	// This member is required.
	RegionList []string

	// The name for the view to be created as part of the Resource Explorer setup. The
	// view name must be unique within the Amazon Web Services account and Region.
	//
	// This member is required.
	ViewName *string

	// A list of Amazon Web Services Regions that should be configured as aggregator
	// Regions. Aggregator Regions receive replicated index information from all other
	// Regions where there is a user-owned index.
	AggregatorRegions []string

	noSmithyDocumentSerde
}

type CreateResourceExplorerSetupOutput struct {

	// The unique identifier for the setup task. Use this ID with
	// GetResourceExplorerSetup to monitor the progress of the configuration operation.
	//
	// This member is required.
	TaskId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateResourceExplorerSetupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateResourceExplorerSetup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateResourceExplorerSetup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateResourceExplorerSetup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateResourceExplorerSetupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateResourceExplorerSetup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateResourceExplorerSetup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateResourceExplorerSetup",
	}
}
