// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/redshift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the lakehouse configuration for a cluster. This operation allows you
// to manage Amazon Redshift federated permissions and Amazon Web Services IAM
// Identity Center trusted identity propagation.
func (c *Client) ModifyLakehouseConfiguration(ctx context.Context, params *ModifyLakehouseConfigurationInput, optFns ...func(*Options)) (*ModifyLakehouseConfigurationOutput, error) {
	if params == nil {
		params = &ModifyLakehouseConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyLakehouseConfiguration", params, optFns, c.addOperationModifyLakehouseConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyLakehouseConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyLakehouseConfigurationInput struct {

	// The unique identifier of the cluster whose lakehouse configuration you want to
	// modify.
	//
	// This member is required.
	ClusterIdentifier *string

	// The name of the Glue data catalog that will be associated with the cluster
	// enabled with Amazon Redshift federated permissions.
	//
	// Constraints:
	//
	//   - Must contain at least one lowercase letter.
	//
	//   - Can only contain lowercase letters (a-z), numbers (0-9), underscores (_),
	//   and hyphens (-).
	//
	// Pattern: ^[a-z0-9_-]*[a-z]+[a-z0-9_-]*$
	//
	// Example: my-catalog_01
	CatalogName *string

	// A boolean value that, if true , validates the request without actually modifying
	// the lakehouse configuration. Use this to check for errors before making changes.
	DryRun *bool

	// The Amazon Resource Name (ARN) of the IAM Identity Center application used for
	// enabling Amazon Web Services IAM Identity Center trusted identity propagation on
	// a cluster enabled with Amazon Redshift federated permissions.
	LakehouseIdcApplicationArn *string

	// Modifies the Amazon Web Services IAM Identity Center trusted identity
	// propagation on a cluster enabled with Amazon Redshift federated permissions.
	// Valid values are Associate or Disassociate .
	LakehouseIdcRegistration types.LakehouseIdcRegistration

	// Specifies whether to register or deregister the cluster with Amazon Redshift
	// federated permissions. Valid values are Register or Deregister .
	LakehouseRegistration types.LakehouseRegistration

	noSmithyDocumentSerde
}

// Contains configuration information for lakehouse integration, including the
// cluster identifier, catalog ARN, and registration status.
type ModifyLakehouseConfigurationOutput struct {

	// The Amazon Resource Name (ARN) of the Glue data catalog associated with the
	// lakehouse configuration.
	CatalogArn *string

	// The unique identifier of the cluster associated with this lakehouse
	// configuration.
	ClusterIdentifier *string

	// The Amazon Resource Name (ARN) of the IAM Identity Center application used for
	// enabling Amazon Web Services IAM Identity Center trusted identity propagation on
	// a cluster enabled with Amazon Redshift federated permissions.
	LakehouseIdcApplicationArn *string

	// The current status of the lakehouse registration. Indicates whether the cluster
	// is successfully registered with the lakehouse.
	LakehouseRegistrationStatus *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyLakehouseConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpModifyLakehouseConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpModifyLakehouseConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyLakehouseConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyLakehouseConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyLakehouseConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyLakehouseConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyLakehouseConfiguration",
	}
}
