// Code generated by smithy-go-codegen DO NOT EDIT.

package redshift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Generates an encrypted authentication token that propagates the caller's Amazon
// Web Services IAM Identity Center identity to Amazon Redshift clusters. This API
// extracts the Amazon Web Services IAM Identity Center identity from enhanced
// credentials and creates a secure token that Amazon Redshift drivers can use for
// authentication.
//
// The token is encrypted using Key Management Service (KMS) and can only be
// decrypted by the specified Amazon Redshift clusters. The token contains the
// caller's Amazon Web Services IAM Identity Center identity information and is
// valid for a limited time period.
//
// This API is exclusively for use with Amazon Web Services IAM Identity Center
// enhanced credentials. If the caller is not using enhanced credentials with
// embedded Amazon Web Services IAM Identity Center identity, the API will return
// an error.
func (c *Client) GetIdentityCenterAuthToken(ctx context.Context, params *GetIdentityCenterAuthTokenInput, optFns ...func(*Options)) (*GetIdentityCenterAuthTokenOutput, error) {
	if params == nil {
		params = &GetIdentityCenterAuthTokenInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIdentityCenterAuthToken", params, optFns, c.addOperationGetIdentityCenterAuthTokenMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIdentityCenterAuthTokenOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request parameters for GetIdentityCenterAuthToken .
type GetIdentityCenterAuthTokenInput struct {

	// A list of cluster identifiers that the generated token can be used with. The
	// token will be scoped to only allow authentication to the specified clusters.
	//
	// Constraints:
	//
	//   - ClusterIds must contain at least 1 cluster identifier.
	//
	//   - ClusterIds can hold a maximum of 20 cluster identifiers.
	//
	//   - Cluster identifiers must be 1 to 63 characters in length.
	//
	//   - The characters accepted for cluster identifiers are the following:
	//
	//   - Alphanumeric characters
	//
	//   - Hyphens
	//
	//   - Cluster identifiers must start with a letter.
	//
	//   - Cluster identifiers can't end with a hyphen or contain two consecutive
	//   hyphens.
	//
	// This member is required.
	ClusterIds []string

	noSmithyDocumentSerde
}

// The response from GetIdentityCenterAuthToken containing the encrypted
// authentication token and expiration time.
type GetIdentityCenterAuthTokenOutput struct {

	// The time (UTC) when the token expires. After this timestamp, the token will no
	// longer be valid for authentication.
	ExpirationTime *time.Time

	// The encrypted authentication token containing the caller's Amazon Web Services
	// IAM Identity Center identity information. This token is encrypted using Key
	// Management Service and can only be decrypted by the specified Amazon Redshift
	// clusters. Use this token with Amazon Redshift drivers to authenticate using your
	// Amazon Web Services IAM Identity Center identity.
	Token *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIdentityCenterAuthTokenMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpGetIdentityCenterAuthToken{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpGetIdentityCenterAuthToken{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIdentityCenterAuthToken"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetIdentityCenterAuthTokenValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIdentityCenterAuthToken(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetIdentityCenterAuthToken(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIdentityCenterAuthToken",
	}
}
