// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates an existing action connector with new configuration details,
// authentication settings, or enabled actions. You can modify the connector's
// name, description, authentication configuration, and which actions are enabled.
// For more information, [https://docs.aws.amazon.com/quicksuite/latest/userguide/quick-action-auth.html].
//
// [https://docs.aws.amazon.com/quicksuite/latest/userguide/quick-action-auth.html]: https://docs.aws.amazon.com/quicksuite/latest/userguide/quick-action-auth.html
func (c *Client) UpdateActionConnector(ctx context.Context, params *UpdateActionConnectorInput, optFns ...func(*Options)) (*UpdateActionConnectorOutput, error) {
	if params == nil {
		params = &UpdateActionConnectorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateActionConnector", params, optFns, c.addOperationUpdateActionConnectorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateActionConnectorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateActionConnectorInput struct {

	// The unique identifier of the action connector to update.
	//
	// This member is required.
	ActionConnectorId *string

	// The updated authentication configuration for connecting to the external service.
	//
	// This member is required.
	AuthenticationConfig *types.AuthConfig

	// The Amazon Web Services account ID that contains the action connector to update.
	//
	// This member is required.
	AwsAccountId *string

	// The new name for the action connector.
	//
	// This member is required.
	Name *string

	// The updated description of the action connector.
	Description *string

	// The updated ARN of the VPC connection to use for secure connectivity.
	VpcConnectionArn *string

	noSmithyDocumentSerde
}

type UpdateActionConnectorOutput struct {

	// The unique identifier of the updated action connector.
	ActionConnectorId *string

	// The Amazon Resource Name (ARN) of the updated action connector.
	Arn *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status code of the request.
	Status int32

	// The status of the update operation.
	UpdateStatus types.ResourceStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateActionConnectorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateActionConnector{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateActionConnector{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateActionConnector"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateActionConnectorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateActionConnector(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateActionConnector(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateActionConnector",
	}
}
