// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Search for the flows in an Amazon Web Services account.
func (c *Client) SearchFlows(ctx context.Context, params *SearchFlowsInput, optFns ...func(*Options)) (*SearchFlowsOutput, error) {
	if params == nil {
		params = &SearchFlowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SearchFlows", params, optFns, c.addOperationSearchFlowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SearchFlowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SearchFlowsInput struct {

	// The ID of the Amazon Web Services account where you are searching for flows
	// from.
	//
	// This member is required.
	AwsAccountId *string

	// The filters applied to the search when searching for flows in the Amazon Web
	// Services account.
	//
	// This member is required.
	Filters []types.SearchFlowsFilter

	// The maximum number of results to be returned per request.
	MaxResults *int32

	// The token to request the next set of results, or null if you want to retrieve
	// the first set.
	NextToken *string

	noSmithyDocumentSerde
}

type SearchFlowsOutput struct {

	// The list of flows found against the search.
	//
	// This member is required.
	FlowSummaryList []types.FlowSummary

	// The token for the next set of results, or null if there are no more results.
	NextToken *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSearchFlowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpSearchFlows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpSearchFlows{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SearchFlows"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSearchFlowsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSearchFlows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// SearchFlowsPaginatorOptions is the paginator options for SearchFlows
type SearchFlowsPaginatorOptions struct {
	// The maximum number of results to be returned per request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// SearchFlowsPaginator is a paginator for SearchFlows
type SearchFlowsPaginator struct {
	options   SearchFlowsPaginatorOptions
	client    SearchFlowsAPIClient
	params    *SearchFlowsInput
	nextToken *string
	firstPage bool
}

// NewSearchFlowsPaginator returns a new SearchFlowsPaginator
func NewSearchFlowsPaginator(client SearchFlowsAPIClient, params *SearchFlowsInput, optFns ...func(*SearchFlowsPaginatorOptions)) *SearchFlowsPaginator {
	if params == nil {
		params = &SearchFlowsInput{}
	}

	options := SearchFlowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &SearchFlowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *SearchFlowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next SearchFlows page.
func (p *SearchFlowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*SearchFlowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.SearchFlows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// SearchFlowsAPIClient is a client that implements the SearchFlows operation.
type SearchFlowsAPIClient interface {
	SearchFlows(context.Context, *SearchFlowsInput, ...func(*Options)) (*SearchFlowsOutput, error)
}

var _ SearchFlowsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opSearchFlows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SearchFlows",
	}
}
