// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Generates a session URL and authorization code that you can use to embed the
// Amazon Amazon Quick Sight console in your web server code. Use
// GetSessionEmbedUrl where you want to provide an authoring portal that allows
// users to create data sources, datasets, analyses, and dashboards. The users who
// access an embedded Amazon Quick Sight console need belong to the author or admin
// security cohort. If you want to restrict permissions to some of these features,
// add a custom permissions profile to the user with the [UpdateUser]API operation. Use [RegisterUser] API
// operation to add a new user with a custom permission profile attached. For more
// information, see the following sections in the Amazon Quick Suite User Guide:
//
// [Embedding Analytics]
//
// [Customizing Access to the Amazon Quick Suite Console]
//
// [UpdateUser]: https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html
// [Customizing Access to the Amazon Quick Suite Console]: https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html
// [RegisterUser]: https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html
// [Embedding Analytics]: https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html
func (c *Client) GetSessionEmbedUrl(ctx context.Context, params *GetSessionEmbedUrlInput, optFns ...func(*Options)) (*GetSessionEmbedUrlOutput, error) {
	if params == nil {
		params = &GetSessionEmbedUrlInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSessionEmbedUrl", params, optFns, c.addOperationGetSessionEmbedUrlMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetSessionEmbedUrlOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetSessionEmbedUrlInput struct {

	// The ID for the Amazon Web Services account associated with your Amazon Quick
	// Sight subscription.
	//
	// This member is required.
	AwsAccountId *string

	// The URL you use to access the embedded session. The entry point URL is
	// constrained to the following paths:
	//
	//   - /start
	//
	//   - /start/analyses
	//
	//   - /start/dashboards
	//
	//   - /start/favorites
	//
	//   - /dashboards/DashboardId - where DashboardId is the actual ID key from the
	//   Amazon Quick Sight console URL of the dashboard
	//
	//   - /analyses/AnalysisId - where AnalysisId is the actual ID key from the Amazon
	//   Quick Sight console URL of the analysis
	EntryPoint *string

	// How many minutes the session is valid. The session lifetime must be 15-600
	// minutes.
	SessionLifetimeInMinutes *int64

	// The Amazon Quick Suite user's Amazon Resource Name (ARN), for use with
	// QUICKSIGHT identity type. You can use this for any type of Amazon Quick Suite
	// users in your account (readers, authors, or admins). They need to be
	// authenticated as one of the following:
	//
	//   - Active Directory (AD) users or group members
	//
	//   - Invited nonfederated users
	//
	//   - IAM users and IAM role-based sessions authenticated through Federated
	//   Single Sign-On using SAML, OpenID Connect, or IAM federation
	//
	// Omit this parameter for users in the third group, IAM users and IAM role-based
	// sessions.
	UserArn *string

	noSmithyDocumentSerde
}

type GetSessionEmbedUrlOutput struct {

	// A single-use URL that you can put into your server-side web page to embed your
	// Quick Suite session. This URL is valid for 5 minutes. The API operation provides
	// the URL with an auth_code value that enables one (and only one) sign-on to a
	// user session that is valid for 10 hours.
	EmbedUrl *string

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The HTTP status of the request.
	Status int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetSessionEmbedUrlMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSessionEmbedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSessionEmbedUrl{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetSessionEmbedUrl"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetSessionEmbedUrlValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSessionEmbedUrl(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSessionEmbedUrl(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetSessionEmbedUrl",
	}
}
