// Code generated by smithy-go-codegen DO NOT EDIT.

package quicksight

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/quicksight/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the metadata of a flow, not including its definition specifying the
// steps.
func (c *Client) GetFlowMetadata(ctx context.Context, params *GetFlowMetadataInput, optFns ...func(*Options)) (*GetFlowMetadataOutput, error) {
	if params == nil {
		params = &GetFlowMetadataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFlowMetadata", params, optFns, c.addOperationGetFlowMetadataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFlowMetadataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFlowMetadataInput struct {

	// The ID of the Amazon Web Services account that contains the flow that you are
	// getting metadata for.
	//
	// This member is required.
	AwsAccountId *string

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowId *string

	noSmithyDocumentSerde
}

type GetFlowMetadataOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time this flow was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The unique identifier of the flow.
	//
	// This member is required.
	FlowId *string

	// A display name for the flow.
	//
	// This member is required.
	Name *string

	// The description for the flow.
	Description *string

	// The last time this flow was modified.
	LastUpdatedTime *time.Time

	// The publish state for the flow. Valid values are DRAFT , PUBLISHED , or
	// PENDING_APPROVAL .
	PublishState types.FlowPublishState

	// The Amazon Web Services request ID for this operation.
	RequestId *string

	// The number of runs done for the flow.
	RunCount int32

	// The HTTP status of the request.
	Status int32

	// The number of users who have used the flow.
	UserCount int32

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFlowMetadataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFlowMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFlowMetadata{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFlowMetadata"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetFlowMetadataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFlowMetadata(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFlowMetadata(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFlowMetadata",
	}
}
