// Code generated by smithy-go-codegen DO NOT EDIT.

package qconnect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/qconnect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists AI Guardrail versions.
func (c *Client) ListAIGuardrailVersions(ctx context.Context, params *ListAIGuardrailVersionsInput, optFns ...func(*Options)) (*ListAIGuardrailVersionsOutput, error) {
	if params == nil {
		params = &ListAIGuardrailVersionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAIGuardrailVersions", params, optFns, c.addOperationListAIGuardrailVersionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAIGuardrailVersionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAIGuardrailVersionsInput struct {

	// The identifier of the Amazon Q in Connect AI Guardrail for which versions are
	// to be listed.
	//
	// This member is required.
	AiGuardrailId *string

	// The identifier of the Amazon Q in Connect assistant. Can be either the ID or
	// the ARN. URLs cannot contain the ARN.
	//
	// This member is required.
	AssistantId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAIGuardrailVersionsOutput struct {

	// The summaries of the AI Guardrail versions.
	//
	// This member is required.
	AiGuardrailVersionSummaries []types.AIGuardrailVersionSummary

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAIGuardrailVersionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAIGuardrailVersions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAIGuardrailVersions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAIGuardrailVersions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListAIGuardrailVersionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAIGuardrailVersions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListAIGuardrailVersionsPaginatorOptions is the paginator options for
// ListAIGuardrailVersions
type ListAIGuardrailVersionsPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAIGuardrailVersionsPaginator is a paginator for ListAIGuardrailVersions
type ListAIGuardrailVersionsPaginator struct {
	options   ListAIGuardrailVersionsPaginatorOptions
	client    ListAIGuardrailVersionsAPIClient
	params    *ListAIGuardrailVersionsInput
	nextToken *string
	firstPage bool
}

// NewListAIGuardrailVersionsPaginator returns a new
// ListAIGuardrailVersionsPaginator
func NewListAIGuardrailVersionsPaginator(client ListAIGuardrailVersionsAPIClient, params *ListAIGuardrailVersionsInput, optFns ...func(*ListAIGuardrailVersionsPaginatorOptions)) *ListAIGuardrailVersionsPaginator {
	if params == nil {
		params = &ListAIGuardrailVersionsInput{}
	}

	options := ListAIGuardrailVersionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAIGuardrailVersionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAIGuardrailVersionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAIGuardrailVersions page.
func (p *ListAIGuardrailVersionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAIGuardrailVersionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAIGuardrailVersions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAIGuardrailVersionsAPIClient is a client that implements the
// ListAIGuardrailVersions operation.
type ListAIGuardrailVersionsAPIClient interface {
	ListAIGuardrailVersions(context.Context, *ListAIGuardrailVersionsInput, ...func(*Options)) (*ListAIGuardrailVersionsOutput, error)
}

var _ ListAIGuardrailVersionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAIGuardrailVersions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAIGuardrailVersions",
	}
}
