// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Displays the attributes associated with a single Amazon Web Services account.
type AccountAttribute struct {

	// The name of the account attribute.
	//
	// This member is required.
	Name AccountAttributeName

	// The value associated with the account attribute name.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The current resource quotas associated with an Amazon Web Services account.
type AccountLimit struct {

	// The Amazon Web Services set limit for that resource type, in US dollars.
	//
	// This member is required.
	Max int64

	// The name of the attribute to apply the account limit to.
	//
	// This member is required.
	Name AccountLimitName

	// The current amount that has been spent, in US dollars.
	//
	// This member is required.
	Used int64

	noSmithyDocumentSerde
}

// Contains the destination configuration to use when publishing message sending
// events.
type CloudWatchLogsDestination struct {

	// The Amazon Resource Name (ARN) of an Identity and Access Management role that
	// is able to write event data to an Amazon CloudWatch destination.
	//
	// This member is required.
	IamRoleArn *string

	// The name of the Amazon CloudWatch log group that you want to record events in.
	//
	// This member is required.
	LogGroupArn *string

	noSmithyDocumentSerde
}

// The information for configuration sets that meet a specified criteria.
type ConfigurationSetFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name ConfigurationSetFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Information related to a given configuration set in your Amazon Web Services
// account.
type ConfigurationSetInformation struct {

	// The Resource Name (ARN) of the ConfigurationSet.
	//
	// This member is required.
	ConfigurationSetArn *string

	// The name of the ConfigurationSet.
	//
	// This member is required.
	ConfigurationSetName *string

	// The time when the ConfigurationSet was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// An array of EventDestination objects that describe any events to log and where
	// to log them.
	//
	// This member is required.
	EventDestinations []EventDestination

	// True if message feedback is enabled.
	DefaultMessageFeedbackEnabled *bool

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
	// time-sensitive.
	DefaultMessageType MessageType

	// The default sender ID used by the ConfigurationSet.
	DefaultSenderId *string

	// The unique identifier for the protect configuration.
	ProtectConfigurationId *string

	noSmithyDocumentSerde
}

// Contains information about an event destination.
//
// Event destinations are associated with configuration sets, which enable you to
// publish message sending events to CloudWatch, Firehose, or Amazon SNS.
type EventDestination struct {

	// When set to true events will be logged.
	//
	// This member is required.
	Enabled *bool

	// The name of the EventDestination.
	//
	// This member is required.
	EventDestinationName *string

	// An array of event types that determine which events to log.
	//
	// The TEXT_SENT event type is not supported.
	//
	// This member is required.
	MatchingEventTypes []EventType

	// An object that contains information about an event destination that sends
	// logging events to Amazon CloudWatch logs.
	CloudWatchLogsDestination *CloudWatchLogsDestination

	// An object that contains information about an event destination for logging to
	// Amazon Data Firehose.
	KinesisFirehoseDestination *KinesisFirehoseDestination

	// An object that contains information about an event destination that sends
	// logging events to Amazon SNS.
	SnsDestination *SnsDestination

	noSmithyDocumentSerde
}

// The information for keywords that meet a specified criteria.
type KeywordFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name KeywordFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The information for all keywords in a pool.
type KeywordInformation struct {

	// The keyword as a string.
	//
	// This member is required.
	Keyword *string

	// The action to perform for the keyword.
	//
	// This member is required.
	KeywordAction KeywordAction

	// A custom message that can be used with the keyword.
	//
	// This member is required.
	KeywordMessage *string

	noSmithyDocumentSerde
}

// Contains the delivery stream Amazon Resource Name (ARN), and the ARN of the
// Identity and Access Management (IAM) role associated with a Firehose event
// destination.
//
// Event destinations, such as Firehose, are associated with configuration sets,
// which enable you to publish message sending events.
type KinesisFirehoseDestination struct {

	// The Amazon Resource Name (ARN) of the delivery stream.
	//
	// This member is required.
	DeliveryStreamArn *string

	// The ARN of an Identity and Access Management role that is able to write event
	// data to an Amazon Data Firehose destination.
	//
	// This member is required.
	IamRoleArn *string

	noSmithyDocumentSerde
}

// The information for opted out numbers that meet a specified criteria.
type OptedOutFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name OptedOutFilterName

	// An array of values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The information for an opted out number in an Amazon Web Services account.
type OptedOutNumberInformation struct {

	// This is set to true if it was the end recipient that opted out.
	//
	// This member is required.
	EndUserOptedOut bool

	// The phone number that is opted out.
	//
	// This member is required.
	OptedOutNumber *string

	// The time that the op tout occurred, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	OptedOutTimestamp *time.Time

	noSmithyDocumentSerde
}

// The information for all OptOutList in an Amazon Web Services account.
type OptOutListInformation struct {

	// The time when the OutOutList was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The Amazon Resource Name (ARN) of the OptOutList.
	//
	// This member is required.
	OptOutListArn *string

	// The name of the OptOutList.
	//
	// This member is required.
	OptOutListName *string

	noSmithyDocumentSerde
}

// The metadata for an origination identity associated with a pool.
type OriginationIdentityMetadata struct {

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// This member is required.
	IsoCountryCode *string

	// Describes if the origination identity can be used for text messages, voice
	// calls or both.
	//
	// This member is required.
	NumberCapabilities []NumberCapability

	// The unique identifier of the origination identity.
	//
	// This member is required.
	OriginationIdentity *string

	// The Amazon Resource Name (ARN) associated with the origination identity.
	//
	// This member is required.
	OriginationIdentityArn *string

	// The phone number in E.164 format.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// The information for a phone number that meets a specified criteria.
type PhoneNumberFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name PhoneNumberFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The information for a phone number, in E.164 format, in an Amazon Web Services
// account.
type PhoneNumberInformation struct {

	// The time when the phone number was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// When set to true the phone number can't be deleted.
	//
	// This member is required.
	DeletionProtectionEnabled bool

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// This member is required.
	IsoCountryCode *string

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
	// time-sensitive.
	//
	// This member is required.
	MessageType MessageType

	// The price, in US dollars, to lease the phone number.
	//
	// This member is required.
	MonthlyLeasingPrice *string

	// Describes if the origination identity can be used for text messages, voice
	// calls or both.
	//
	// This member is required.
	NumberCapabilities []NumberCapability

	// The type of phone number.
	//
	// This member is required.
	NumberType NumberType

	// The name of the OptOutList associated with the phone number.
	//
	// This member is required.
	OptOutListName *string

	// The phone number in E.164 format.
	//
	// This member is required.
	PhoneNumber *string

	// The Amazon Resource Name (ARN) associated with the phone number.
	//
	// This member is required.
	PhoneNumberArn *string

	// When set to false and an end recipient sends a message that begins with HELP or
	// STOP to one of your dedicated numbers, End User MessagingSMS automatically
	// replies with a customizable message and adds the end recipient to the
	// OptOutList. When set to true you're responsible for responding to HELP and STOP
	// requests. You're also responsible for tracking and honoring opt-out request. For
	// more information see [Self-managed opt-outs]
	//
	// [Self-managed opt-outs]: https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out
	//
	// This member is required.
	SelfManagedOptOutsEnabled bool

	// The current status of the phone number.
	//
	// This member is required.
	Status NumberStatus

	// By default this is set to false. When set to true you can receive incoming text
	// messages from your end recipients using the TwoWayChannelArn.
	//
	// This member is required.
	TwoWayEnabled bool

	// When set to true the international sending of phone number is Enabled.
	InternationalSendingEnabled bool

	// The unique identifier for the phone number.
	PhoneNumberId *string

	// The unique identifier of the pool associated with the phone number.
	PoolId *string

	// The unique identifier for the registration.
	RegistrationId *string

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string

	// An optional IAM Role Arn for a service to assume, to be able to post inbound
	// SMS messages.
	TwoWayChannelRole *string

	noSmithyDocumentSerde
}

// The information for a pool that meets a specified criteria.
type PoolFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name PoolFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The information for a pool in an Amazon Web Services account.
type PoolInformation struct {

	// The time when the pool was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// When set to true the pool can't be deleted.
	//
	// This member is required.
	DeletionProtectionEnabled bool

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
	// time-sensitive.
	//
	// This member is required.
	MessageType MessageType

	// The name of the OptOutList associated with the pool.
	//
	// This member is required.
	OptOutListName *string

	// The Amazon Resource Name (ARN) for the pool.
	//
	// This member is required.
	PoolArn *string

	// The unique identifier for the pool.
	//
	// This member is required.
	PoolId *string

	// When set to false, an end recipient sends a message that begins with HELP or
	// STOP to one of your dedicated numbers, End User MessagingSMS automatically
	// replies with a customizable message and adds the end recipient to the
	// OptOutList. When set to true you're responsible for responding to HELP and STOP
	// requests. You're also responsible for tracking and honoring opt-out requests.
	// For more information see [Self-managed opt-outs]
	//
	// [Self-managed opt-outs]: https://docs.aws.amazon.com/pinpoint/latest/userguide/settings-sms-managing.html#settings-account-sms-self-managed-opt-out
	//
	// This member is required.
	SelfManagedOptOutsEnabled bool

	// Allows you to enable shared routes on your pool.
	//
	// By default, this is set to False . If you set this value to True , your messages
	// are sent using phone numbers or sender IDs (depending on the country) that are
	// shared with other users. In some countries, such as the United States, senders
	// aren't allowed to use shared routes and must use a dedicated phone number or
	// short code.
	//
	// This member is required.
	SharedRoutesEnabled bool

	// The current status of the pool.
	//
	// This member is required.
	Status PoolStatus

	// When set to true you can receive incoming text messages from your end
	// recipients using the TwoWayChannelArn.
	//
	// This member is required.
	TwoWayEnabled bool

	// The Amazon Resource Name (ARN) of the two way channel.
	TwoWayChannelArn *string

	// An optional IAM Role Arn for a service to assume, to be able to post inbound
	// SMS messages.
	TwoWayChannelRole *string

	noSmithyDocumentSerde
}

// Information about origination identities associated with a pool that meets a
// specified criteria.
type PoolOriginationIdentitiesFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name PoolOriginationIdentitiesFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The types of statuses that can be used.
type ProtectConfigurationCountryRuleSetInformation struct {

	// The types of protection that can be used.
	//
	// This member is required.
	ProtectStatus ProtectStatus

	noSmithyDocumentSerde
}

// The filter definition for filtering protect configurations that meet a
// specified criteria.
type ProtectConfigurationFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name ProtectConfigurationFilterName

	// An array of values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information on the specified protect configuration.
type ProtectConfigurationInformation struct {

	// This is true if the protect configuration is set as your account default
	// protect configuration.
	//
	// This member is required.
	AccountDefault bool

	// The time when the protect configuration was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The status of deletion protection for the protect configuration. When set to
	// true deletion protection is enabled. By default this is set to false.
	//
	// This member is required.
	DeletionProtectionEnabled bool

	// The Amazon Resource Name (ARN) of the protect configuration.
	//
	// This member is required.
	ProtectConfigurationArn *string

	// The unique identifier for the protect configuration.
	//
	// This member is required.
	ProtectConfigurationId *string

	noSmithyDocumentSerde
}

// Provides details on phone number rule overrides for a protect configuration.
type ProtectConfigurationRuleSetNumberOverride struct {

	// The action for the rule to perform of either blocking or allowing messages to
	// the destination phone number.
	//
	// This member is required.
	Action ProtectConfigurationRuleOverrideAction

	// The time when the rule was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The destination phone number in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// The time the rule will expire at. If ExpirationTimestamp is not set then the
	// rule will not expire.
	ExpirationTimestamp *time.Time

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
	IsoCountryCode *string

	noSmithyDocumentSerde
}

// The information for a protect configuration rule set number override that meets
// a specified criteria.
type ProtectConfigurationRuleSetNumberOverrideFilterItem struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name ProtectConfigurationRuleSetNumberOverrideFilterName

	// An array values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The filter definition for filtering registrations that meets a specified
// criteria.
type RegistrationAssociationFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name RegistrationAssociationFilterName

	// An array of values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Metadata for the origination identity that is associated with the registration.
type RegistrationAssociationMetadata struct {

	// The Amazon Resource Name (ARN) of the origination identity that is associated
	// with the registration.
	//
	// This member is required.
	ResourceArn *string

	// The unique identifier for the origination identity. For example this could be a
	// PhoneNumberId or SenderId.
	//
	// This member is required.
	ResourceId *string

	// The origination identity type.
	//
	// This member is required.
	ResourceType *string

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
	IsoCountryCode *string

	// The phone number associated with the registration in E.164 format.
	PhoneNumber *string

	noSmithyDocumentSerde
}

// The filter definition for filtering registration attachments that meets a
// specified criteria.
type RegistrationAttachmentFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name RegistrationAttachmentFilterName

	// An array of values to filter on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information on the specified registration attachments.
type RegistrationAttachmentsInformation struct {

	// The status of the registration attachment.
	//
	//   - UPLOAD_IN_PROGRESS The attachment is being uploaded.
	//
	//   - UPLOAD_COMPLETE The attachment has been uploaded.
	//
	//   - UPLOAD_FAILED The attachment failed to uploaded.
	//
	//   - DELETED The attachment has been deleted..
	//
	// This member is required.
	AttachmentStatus AttachmentStatus

	// The time when the registration attachment was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The Amazon Resource Name (ARN) for the registration attachment.
	//
	// This member is required.
	RegistrationAttachmentArn *string

	// The unique identifier for the registration attachment.
	//
	// This member is required.
	RegistrationAttachmentId *string

	// A description of why the upload didn't successfully complete.
	AttachmentUploadErrorReason AttachmentUploadErrorReason

	noSmithyDocumentSerde
}

// Provides the reason a registration was rejected.
type RegistrationDeniedReasonInformation struct {

	// The reason a registration was rejected.
	//
	// This member is required.
	Reason *string

	// A short description of the rejection reason.
	//
	// This member is required.
	ShortDescription *string

	// The link to the document.
	DocumentationLink *string

	// The title of the document.
	DocumentationTitle *string

	// A long description of the rejection reason.
	LongDescription *string

	noSmithyDocumentSerde
}

// Provides a description of the specified field.
type RegistrationFieldDefinition struct {

	// An array of RegistrationFieldDisplayHints objects for the field.
	//
	// This member is required.
	DisplayHints *RegistrationFieldDisplayHints

	// The path to the registration form field. You can use DescribeRegistrationFieldDefinitions for a list of FieldPaths.
	//
	// This member is required.
	FieldPath *string

	// Specifies if the field for the registration form is required, conditional or
	// optional.
	//
	// This member is required.
	FieldRequirement FieldRequirement

	// The type of field.
	//
	// This member is required.
	FieldType FieldType

	// The section path of the field.
	//
	// This member is required.
	SectionPath *string

	// The validation rules for a select field.
	SelectValidation *SelectValidation

	// The validation rules for a text field.
	TextValidation *TextValidation

	noSmithyDocumentSerde
}

// Provides help information on the registration field.
type RegistrationFieldDisplayHints struct {

	// A short description of the display hint.
	//
	// This member is required.
	ShortDescription *string

	// The title of the display hint.
	//
	// This member is required.
	Title *string

	// The link to the document the display hint is associated with.
	DocumentationLink *string

	// The title of the document the display hint is associated with.
	DocumentationTitle *string

	// Example text of what the value of a field should contain.
	ExampleTextValue *string

	// A full description of the display hint.
	LongDescription *string

	// An array of SelectOptionDescription objects.
	SelectOptionDescriptions []SelectOptionDescription

	// The validation rules for the text field.
	TextValidationDescription *string

	noSmithyDocumentSerde
}

// Provides the values of the specified field.
type RegistrationFieldValueInformation struct {

	// The path to the registration form field. You can use DescribeRegistrationFieldDefinitions for a list of FieldPaths.
	//
	// This member is required.
	FieldPath *string

	// A description of why the registration was denied.
	DeniedReason *string

	// The unique identifier for the registration attachment.
	RegistrationAttachmentId *string

	// An array of values for the form field.
	SelectChoices []string

	// The text data for a free form field.
	TextValue *string

	noSmithyDocumentSerde
}

// The filter definition for filtering registrations that meets a specified
// criteria.
type RegistrationFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name RegistrationFilterName

	// An array of values to filter on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about the requested registration.
type RegistrationInformation struct {

	// The time when the registration was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The current version number of the registration.
	//
	// This member is required.
	CurrentVersionNumber *int64

	// The Amazon Resource Name (ARN) for the registration.
	//
	// This member is required.
	RegistrationArn *string

	// The unique identifier for the registration.
	//
	// This member is required.
	RegistrationId *string

	// The status of the registration.
	//
	//   - CLOSED : The phone number or sender ID has been deleted and you must also
	//   delete the registration for the number.
	//
	//   - CREATED : Your registration is created but not submitted.
	//
	//   - COMPLETE : Your registration has been approved and your origination identity
	//   has been created.
	//
	//   - DELETED : The registration has been deleted.
	//
	//   - PROVISIONING : Your registration has been approved and your origination
	//   identity is being created.
	//
	//   - REQUIRES_AUTHENTICATION : You need to complete email authentication.
	//
	//   - REQUIRES_UPDATES : You must fix your registration and resubmit it.
	//
	//   - REVIEWING : Your registration has been accepted and is being reviewed.
	//
	//   - SUBMITTED : Your registration has been submitted and is awaiting review.
	//
	// This member is required.
	RegistrationStatus RegistrationStatus

	// The type of registration form. The list of RegistrationTypes can be found using
	// the DescribeRegistrationTypeDefinitionsaction.
	//
	// This member is required.
	RegistrationType *string

	// Metadata about a given registration which is specific to that registration type.
	AdditionalAttributes map[string]string

	// The version number of the registration that was approved.
	ApprovedVersionNumber *int64

	// The latest version number of the registration that was denied.
	LatestDeniedVersionNumber *int64

	noSmithyDocumentSerde
}

// Provides information on the specified section definition.
type RegistrationSectionDefinition struct {

	// The path to the section of the registration.
	//
	// This member is required.
	DisplayHints *RegistrationSectionDisplayHints

	// The path to the section of the registration.
	//
	// This member is required.
	SectionPath *string

	noSmithyDocumentSerde
}

// Provides help information on the registration section.
type RegistrationSectionDisplayHints struct {

	// A short description of the display hint.
	//
	// This member is required.
	ShortDescription *string

	// The title of the display hint.
	//
	// This member is required.
	Title *string

	// The link to the document the display hint is associated with.
	DocumentationLink *string

	// The title of the document the display hint is associated with.
	DocumentationTitle *string

	// A full description of the display hint.
	LongDescription *string

	noSmithyDocumentSerde
}

// Provides information on the supported registration type.
type RegistrationTypeDefinition struct {

	// Provides help information on the registration.
	//
	// This member is required.
	DisplayHints *RegistrationTypeDisplayHints

	// The type of registration form. The list of RegistrationTypes can be found using
	// the DescribeRegistrationTypeDefinitionsaction.
	//
	// This member is required.
	RegistrationType *string

	// The supported association behavior for the registration type.
	SupportedAssociations []SupportedAssociation

	noSmithyDocumentSerde
}

// Provides help information on the registration type.
type RegistrationTypeDisplayHints struct {

	// The title of the display hint.
	//
	// This member is required.
	Title *string

	// The link to the document the display hint is associated with.
	DocumentationLink *string

	// The title of the document the display hint is associated with.
	DocumentationTitle *string

	// A full description of the display hint.
	LongDescription *string

	// A short description of the display hint.
	ShortDescription *string

	noSmithyDocumentSerde
}

// The filter definition for filtering registration types that meets a specified
// criteria.
type RegistrationTypeFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name RegistrationTypeFilterName

	// An array of values to filter on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The filter definition for filtering registration versions that meets a
// specified criteria.
type RegistrationVersionFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name RegistrationVersionFilterName

	// An array of values to filter on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about the specified version of the registration.
type RegistrationVersionInformation struct {

	// The status of the registration.
	//
	//   - APPROVED : Your registration has been approved.
	//
	//   - ARCHIVED : Your previously approved registration version moves into this
	//   status when a more recently submitted version is approved.
	//
	//   - DENIED : You must fix your registration and resubmit it.
	//
	//   - DISCARDED : You've abandon this version of their registration to start over
	//   with a new version.
	//
	//   - DRAFT : The initial status of a registration version after it’s created.
	//
	//   - REQUIRES_AUTHENTICATION : You need to complete email authentication.
	//
	//   - REVIEWING : Your registration has been accepted and is being reviewed.
	//
	//   - REVOKED : Your previously approved registration has been revoked.
	//
	//   - SUBMITTED : Your registration has been submitted.
	//
	// This member is required.
	RegistrationVersionStatus RegistrationVersionStatus

	// The RegistrationVersionStatusHistory object contains the time stamps for when
	// the reservations status changes.
	//
	// This member is required.
	RegistrationVersionStatusHistory *RegistrationVersionStatusHistory

	// The version number of the registration.
	//
	// This member is required.
	VersionNumber *int64

	// An array of RegistrationDeniedReasonInformation objects.
	DeniedReasons []RegistrationDeniedReasonInformation

	noSmithyDocumentSerde
}

// The RegistrationVersionStatusHistory object contains the time stamps for when
// the reservations status changes.
type RegistrationVersionStatusHistory struct {

	// The time when the registration was in the draft state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	DraftTimestamp *time.Time

	// The time when the registration was in the approved state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	ApprovedTimestamp *time.Time

	// The time when the registration was in the archived state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	ArchivedTimestamp *time.Time

	// The time when the registration was in the denied state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	DeniedTimestamp *time.Time

	// The time when the registration was in the discarded state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	DiscardedTimestamp *time.Time

	// The time when the registration was in the requires authentication state, in [UNIX epoch time]
	// format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	RequiresAuthenticationTimestamp *time.Time

	// The time when the registration was in the reviewing state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	ReviewingTimestamp *time.Time

	// The time when the registration was in the revoked state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	RevokedTimestamp *time.Time

	// The time when the registration was in the submitted state, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	SubmittedTimestamp *time.Time

	noSmithyDocumentSerde
}

// A description of each select option.
type SelectOptionDescription struct {

	// The value of the option.
	//
	// This member is required.
	Option *string

	// A description of the option meaning.
	Description *string

	// The title of the select option.
	Title *string

	noSmithyDocumentSerde
}

// Validation rules for a select field.
type SelectValidation struct {

	// The maximum number of choices for the select.
	//
	// This member is required.
	MaxChoices *int32

	// The minimum number of choices for the select.
	//
	// This member is required.
	MinChoices *int32

	// An array of strings for the possible selection options.
	//
	// This member is required.
	Options []string

	noSmithyDocumentSerde
}

//	The alphanumeric sender ID in a specific country that you want to describe.
//
// For more information on sender IDs see [Requesting sender IDs]in the End User MessagingSMS User Guide.
//
// [Requesting sender IDs]: https://docs.aws.amazon.com/sms-voice/latest/userguide/sender-id-request.html
type SenderIdAndCountry struct {

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// This member is required.
	IsoCountryCode *string

	// The unique identifier of the sender.
	//
	// This member is required.
	SenderId *string

	noSmithyDocumentSerde
}

// The information for a sender ID that meets a specified criteria.
type SenderIdFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name SenderIdFilterName

	// An array of values to filter for.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// The information for all SenderIds in an Amazon Web Services account.
type SenderIdInformation struct {

	// By default this is set to false. When set to true the sender ID can't be
	// deleted.
	//
	// This member is required.
	DeletionProtectionEnabled bool

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or
	// region.
	//
	// This member is required.
	IsoCountryCode *string

	// The type of message. Valid values are TRANSACTIONAL for messages that are
	// critical or time-sensitive and PROMOTIONAL for messages that aren't critical or
	// time-sensitive.
	//
	// This member is required.
	MessageTypes []MessageType

	// The monthly leasing price, in US dollars.
	//
	// This member is required.
	MonthlyLeasingPrice *string

	// True if the sender ID is registered.
	//
	// This member is required.
	Registered bool

	// The alphanumeric sender ID in a specific country that you'd like to describe.
	//
	// This member is required.
	SenderId *string

	// The Amazon Resource Name (ARN) associated with the SenderId.
	//
	// This member is required.
	SenderIdArn *string

	// The unique identifier for the registration.
	RegistrationId *string

	noSmithyDocumentSerde
}

// An object that defines an Amazon SNS destination for events. You can use Amazon
// SNS to send notification when certain events occur.
type SnsDestination struct {

	// The Amazon Resource Name (ARN) of the Amazon SNS topic that you want to publish
	// events to.
	//
	// This member is required.
	TopicArn *string

	noSmithyDocumentSerde
}

// Describes the current monthly spend limits for sending voice and text messages.
// For more information on increasing your monthly spend limit, see [Requesting a spending quota increase]in the End
// User MessagingSMS User Guide.
//
// [Requesting a spending quota increase]: https://docs.aws.amazon.com/sms-voice/latest/userguide/awssupport-spend-threshold.html
type SpendLimit struct {

	// The maximum amount of money, in US dollars, that you want to be able to spend
	// sending messages each month. This value has to be less than or equal to the
	// amount in MaxLimit . To use this custom limit, Overridden must be set to true.
	//
	// This member is required.
	EnforcedLimit int64

	//  The maximum amount of money that you are able to spend to send messages each
	// month, in US dollars.
	//
	// This member is required.
	MaxLimit int64

	// The name for the SpendLimit.
	//
	// This member is required.
	Name SpendLimitName

	// When set to True , the value that has been specified in the EnforcedLimit is
	// used to determine the maximum amount in US dollars that can be spent to send
	// messages each month, in US dollars.
	//
	// This member is required.
	Overridden bool

	noSmithyDocumentSerde
}

// The processing rules for when a registration can be associated with an
// origination identity and disassociated from an origination identity.
type SupportedAssociation struct {

	// The association behavior.
	//
	//   - ASSOCIATE_BEFORE_SUBMIT The origination identity has to be supplied when
	//   creating a registration.
	//
	//   - ASSOCIATE_ON_APPROVAL This applies to all sender ID registrations. The
	//   sender ID will be automatically provisioned once the registration is approved.
	//
	//   - ASSOCIATE_AFTER_COMPLETE This applies to phone number registrations when you
	//   must complete a registration first, then associate one or more phone numbers
	//   later. For example 10DLC campaigns and long codes.
	//
	// This member is required.
	AssociationBehavior RegistrationAssociationBehavior

	// The disassociation behavior.
	//
	//   - DISASSOCIATE_ALL_CLOSES_REGISTRATION All origination identities must be
	//   disassociated from the registration before the registration can be closed.
	//
	//   - DISASSOCIATE_ALL_ALLOWS_DELETE_REGISTRATION All origination identities must
	//   be disassociated from the registration before the registration can be deleted.
	//
	//   - DELETE_REGISTRATION_DISASSOCIATES The registration can be deleted and all
	//   origination identities will be disasscoiated.
	//
	// This member is required.
	DisassociationBehavior RegistrationDisassociationBehavior

	// Defines the behavior of when an origination identity and registration can be
	// associated with each other.
	//
	// This member is required.
	ResourceType *string

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or region.
	IsoCountryCode *string

	noSmithyDocumentSerde
}

// The list of tags to be added to the specified topic.
type Tag struct {

	// The key identifier, or name, of the tag.
	//
	// This member is required.
	Key *string

	// The string value associated with the key of the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Validation rules for a text field.
type TextValidation struct {

	// The maximum number of characters for the text field.
	//
	// This member is required.
	MaxLength *int32

	// The minimum number of characters for the text field.
	//
	// This member is required.
	MinLength *int32

	// The regular expression used to validate the text field.
	//
	// This member is required.
	Pattern *string

	noSmithyDocumentSerde
}

// The field associated with the validation exception.
type ValidationExceptionField struct {

	// The message associated with the validation exception with information to help
	// determine its cause.
	//
	// This member is required.
	Message *string

	// The name of the field.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The filter definition for filtering verified destination phone numbers that
// meets a specified criteria.
type VerifiedDestinationNumberFilter struct {

	// The name of the attribute to filter on.
	//
	// This member is required.
	Name VerifiedDestinationNumberFilterName

	// An array of values to filter on.
	//
	// This member is required.
	Values []string

	noSmithyDocumentSerde
}

// Provides information about the requested verified destintion phone number.
type VerifiedDestinationNumberInformation struct {

	// The time when the destination phone number was created, in [UNIX epoch time] format.
	//
	// [UNIX epoch time]: https://www.epochconverter.com/
	//
	// This member is required.
	CreatedTimestamp *time.Time

	// The verified destination phone number, in E.164 format.
	//
	// This member is required.
	DestinationPhoneNumber *string

	// The status of the verified destination phone number.
	//
	//   - PENDING : The phone number hasn't been verified yet.
	//
	//   - VERIFIED : The phone number is verified and can receive messages.
	//
	// This member is required.
	Status VerificationStatus

	// The Amazon Resource Name (ARN) for the verified destination phone number.
	//
	// This member is required.
	VerifiedDestinationNumberArn *string

	// The unique identifier for the verified destination phone number.
	//
	// This member is required.
	VerifiedDestinationNumberId *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
