// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about a destination phone number, including whether the
// number type and whether it is valid, the carrier, and more.
func (c *Client) CarrierLookup(ctx context.Context, params *CarrierLookupInput, optFns ...func(*Options)) (*CarrierLookupOutput, error) {
	if params == nil {
		params = &CarrierLookupInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CarrierLookup", params, optFns, c.addOperationCarrierLookupMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CarrierLookupOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CarrierLookupInput struct {

	// The phone number that you want to retrieve information about. You can provide
	// the phone number in various formats including special characters such as
	// parentheses, brackets, spaces, hyphens, periods, and commas. The service
	// automatically converts the input to E164 format for processing.
	//
	// This member is required.
	PhoneNumber *string

	noSmithyDocumentSerde
}

type CarrierLookupOutput struct {

	// The phone number in E164 format, sanitized from the original input by removing
	// any formatting characters.
	//
	// This member is required.
	E164PhoneNumber *string

	// Describes the type of phone number. Valid values are: MOBILE, LANDLINE, OTHER,
	// and INVALID. Avoid sending SMS or voice messages to INVALID phone numbers, as
	// these numbers are unlikely to belong to actual recipients.
	//
	// This member is required.
	PhoneNumberType types.PhoneNumberType

	// The carrier or service provider that the phone number is currently registered
	// with. In some countries and regions, this value may be the carrier or service
	// provider that the phone number was originally registered with.
	Carrier *string

	// The name of the country where the phone number was originally registered.
	Country *string

	// The numeric dialing code for the country or region where the phone number was
	// originally registered.
	DialingCountryCode *string

	// The two-character code, in ISO 3166-1 alpha-2 format, for the country or region
	// where the phone number was originally registered.
	IsoCountryCode *string

	// The phone number's mobile country code, for mobile phone number types
	MCC *string

	// The phone number's mobile network code, for mobile phone number types.
	MNC *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCarrierLookupMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCarrierLookup{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCarrierLookup{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CarrierLookup"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCarrierLookupValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCarrierLookup(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCarrierLookup(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CarrierLookup",
	}
}
