// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptographydata

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptographydata/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Translates an encryption key between different wrapping keys without importing
// the key into Amazon Web Services Payment Cryptography.
//
// This operation can be used when key material is frequently rotated, such as
// during every card transaction, and there is a need to avoid importing
// short-lived keys into Amazon Web Services Payment Cryptography. It translates
// short-lived transaction keys such as Pin Encryption Key (PEK) generated for each
// transaction and wrapped with an ECDH (Elliptic Curve Diffie-Hellman) derived
// wrapping key to another KEK (Key Encryption Key) wrapping key.
//
// Before using this operation, you must first request the public key certificate
// of the ECC key pair generated within Amazon Web Services Payment Cryptography to
// establish an ECDH key agreement. In TranslateKeyData , the service uses its own
// ECC key pair, public certificate of receiving ECC key pair, and the key
// derivation parameters to generate a derived key. The service uses this derived
// key to unwrap the incoming transaction key received as a TR31WrappedKeyBlock and
// re-wrap using a user provided KEK to generate an outgoing Tr31WrappedKeyBlock.
// For more information on establishing ECDH derived keys, see the [Creating keys]in the Amazon
// Web Services Payment Cryptography User Guide.
//
// For information about valid keys for this operation, see [Understanding key attributes] and [Key types for specific data operations] in the Amazon
// Web Services Payment Cryptography User Guide.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [CreateKey]
//
// [GetPublicCertificate]
//
// [ImportKey]
//
// [Creating keys]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/create-keys.html
// [GetPublicCertificate]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetPublicKeyCertificate.html
// [Key types for specific data operations]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/crypto-ops-validkeys-ops.html
// [ImportKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_ImportKey.html
// [Understanding key attributes]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-validattributes.html
// [CreateKey]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_CreateKey.html
func (c *Client) TranslateKeyMaterial(ctx context.Context, params *TranslateKeyMaterialInput, optFns ...func(*Options)) (*TranslateKeyMaterialOutput, error) {
	if params == nil {
		params = &TranslateKeyMaterialInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "TranslateKeyMaterial", params, optFns, c.addOperationTranslateKeyMaterialMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*TranslateKeyMaterialOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type TranslateKeyMaterialInput struct {

	// Parameter information of the TR31WrappedKeyBlock containing the transaction key.
	//
	// This member is required.
	IncomingKeyMaterial types.IncomingKeyMaterial

	// Parameter information of the wrapping key used to wrap the transaction key in
	// the outgoing TR31WrappedKeyBlock.
	//
	// This member is required.
	OutgoingKeyMaterial types.OutgoingKeyMaterial

	// The key check value (KCV) algorithm used for calculating the KCV.
	KeyCheckValueAlgorithm types.KeyCheckValueAlgorithm

	noSmithyDocumentSerde
}

type TranslateKeyMaterialOutput struct {

	// The outgoing KEK wrapped TR31WrappedKeyBlock.
	//
	// This member is required.
	WrappedKey *types.WrappedWorkingKey

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationTranslateKeyMaterialMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpTranslateKeyMaterial{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpTranslateKeyMaterial{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "TranslateKeyMaterial"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpTranslateKeyMaterialValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opTranslateKeyMaterial(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opTranslateKeyMaterial(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "TranslateKeyMaterial",
	}
}
