// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/paymentcryptography/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes Replication Regions from an existing Amazon Web Services Payment
// Cryptography key, disabling the key's availability for cryptographic operations
// in the specified Amazon Web Services Regions.
//
// When you remove Replication Regions, the key material is securely deleted from
// those regions and can no longer be used for cryptographic operations there. This
// operation is irreversible for the specified Amazon Web Services Regions. For
// more information, see [Multi-Region key replication].
//
// Ensure that no active cryptographic operations or applications depend on the
// key in the regions you're removing before performing this operation.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [AddKeyReplicationRegions]
//
// [DisableDefaultKeyReplicationRegions]
//
// [Multi-Region key replication]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html
// [DisableDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DisableDefaultKeyReplicationRegions.html
// [AddKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_AddKeyReplicationRegions.html
func (c *Client) RemoveKeyReplicationRegions(ctx context.Context, params *RemoveKeyReplicationRegionsInput, optFns ...func(*Options)) (*RemoveKeyReplicationRegionsOutput, error) {
	if params == nil {
		params = &RemoveKeyReplicationRegionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "RemoveKeyReplicationRegions", params, optFns, c.addOperationRemoveKeyReplicationRegionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*RemoveKeyReplicationRegionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input parameters for removing replication regions from a specific key.
type RemoveKeyReplicationRegionsInput struct {

	// The key identifier (ARN or alias) of the key from which to remove replication
	// regions.
	//
	// This key must exist and have replication enabled in the specified regions.
	//
	// This member is required.
	KeyIdentifier *string

	// The list of Amazon Web Services Regions to remove from the key's replication
	// configuration.
	//
	// The key will no longer be available for cryptographic operations in these
	// regions after removal. Ensure no active operations depend on the key in these
	// regions before removal.
	//
	// This member is required.
	ReplicationRegions []string

	noSmithyDocumentSerde
}

// Output from removing replication regions from a key.
type RemoveKeyReplicationRegionsOutput struct {

	// The updated key metadata after removing the replication regions.
	//
	// This reflects the current state of the key and its updated replication
	// configuration.
	//
	// This member is required.
	Key *types.Key

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationRemoveKeyReplicationRegionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpRemoveKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpRemoveKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "RemoveKeyReplicationRegions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpRemoveKeyReplicationRegionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opRemoveKeyReplicationRegions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opRemoveKeyReplicationRegions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "RemoveKeyReplicationRegions",
	}
}
