// Code generated by smithy-go-codegen DO NOT EDIT.

package paymentcryptography

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Enables [Multi-Region key replication] settings for your Amazon Web Services account, causing new keys to be
// automatically replicated to the specified Amazon Web Services Regions when
// created.
//
// When Multi-Region key replication are enabled, any new keys created in your
// account will automatically be replicated to these regions unless you explicitly
// override this behavior during key creation. This simplifies key management for
// applications that operate across multiple regions.
//
// Existing keys are not affected by this operation - only keys created after
// enabling default replication will be automatically replicated.
//
// Cross-account use: This operation can't be used across different Amazon Web
// Services accounts.
//
// Related operations:
//
// [DisableDefaultKeyReplicationRegions]
//
// [GetDefaultKeyReplicationRegions]
//
// [Multi-Region key replication]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html
// [DisableDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_DisableDefaultKeyReplicationRegions.html
// [GetDefaultKeyReplicationRegions]: https://docs.aws.amazon.com/payment-cryptography/latest/APIReference/API_GetDefaultKeyReplicationRegions.html
func (c *Client) EnableDefaultKeyReplicationRegions(ctx context.Context, params *EnableDefaultKeyReplicationRegionsInput, optFns ...func(*Options)) (*EnableDefaultKeyReplicationRegionsOutput, error) {
	if params == nil {
		params = &EnableDefaultKeyReplicationRegionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "EnableDefaultKeyReplicationRegions", params, optFns, c.addOperationEnableDefaultKeyReplicationRegionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*EnableDefaultKeyReplicationRegionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Input parameters for enabling default key replication regions for the account.
type EnableDefaultKeyReplicationRegionsInput struct {

	// The list of Amazon Web Services Regions to enable as default replication
	// regions for the Amazon Web Services account for [Multi-Region key replication].
	//
	// New keys created in this account will automatically be replicated to these
	// regions unless explicitly overridden during key creation.
	//
	// [Multi-Region key replication]: https://docs.aws.amazon.com/payment-cryptography/latest/userguide/keys-multi-region-replication.html
	//
	// This member is required.
	ReplicationRegions []string

	noSmithyDocumentSerde
}

// Output from enabling default key replication regions for the account.
type EnableDefaultKeyReplicationRegionsOutput struct {

	// The complete list of regions where default key replication is now enabled for
	// the account.
	//
	// This includes both previously enabled regions and the newly added regions from
	// this operation.
	//
	// This member is required.
	EnabledReplicationRegions []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationEnableDefaultKeyReplicationRegionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpEnableDefaultKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpEnableDefaultKeyReplicationRegions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "EnableDefaultKeyReplicationRegions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpEnableDefaultKeyReplicationRegionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opEnableDefaultKeyReplicationRegions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opEnableDefaultKeyReplicationRegions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "EnableDefaultKeyReplicationRegions",
	}
}
